package org.openqa.selenium.devtools.v142.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class AttributionReportingSourceRegistration {

    private final org.openqa.selenium.devtools.v142.network.model.TimeSinceEpoch time;

    private final java.lang.Integer expiry;

    private final java.util.List<java.lang.Number> triggerData;

    private final org.openqa.selenium.devtools.v142.storage.model.AttributionReportingEventReportWindows eventReportWindows;

    private final java.lang.Integer aggregatableReportWindow;

    private final org.openqa.selenium.devtools.v142.storage.model.AttributionReportingSourceType type;

    private final java.lang.String sourceOrigin;

    private final java.lang.String reportingOrigin;

    private final java.util.List<java.lang.String> destinationSites;

    private final org.openqa.selenium.devtools.v142.storage.model.UnsignedInt64AsBase10 eventId;

    private final org.openqa.selenium.devtools.v142.storage.model.SignedInt64AsBase10 priority;

    private final java.util.List<org.openqa.selenium.devtools.v142.storage.model.AttributionReportingFilterDataEntry> filterData;

    private final java.util.List<org.openqa.selenium.devtools.v142.storage.model.AttributionReportingAggregationKeysEntry> aggregationKeys;

    private final java.util.Optional<org.openqa.selenium.devtools.v142.storage.model.UnsignedInt64AsBase10> debugKey;

    private final org.openqa.selenium.devtools.v142.storage.model.AttributionReportingTriggerDataMatching triggerDataMatching;

    private final org.openqa.selenium.devtools.v142.storage.model.SignedInt64AsBase10 destinationLimitPriority;

    private final org.openqa.selenium.devtools.v142.storage.model.AttributionReportingAggregatableDebugReportingConfig aggregatableDebugReportingConfig;

    private final java.util.Optional<org.openqa.selenium.devtools.v142.storage.model.AttributionScopesData> scopesData;

    private final java.lang.Integer maxEventLevelReports;

    private final java.util.List<org.openqa.selenium.devtools.v142.storage.model.AttributionReportingNamedBudgetDef> namedBudgets;

    private final java.lang.Boolean debugReporting;

    private final java.lang.Number eventLevelEpsilon;

    public AttributionReportingSourceRegistration(org.openqa.selenium.devtools.v142.network.model.TimeSinceEpoch time, java.lang.Integer expiry, java.util.List<java.lang.Number> triggerData, org.openqa.selenium.devtools.v142.storage.model.AttributionReportingEventReportWindows eventReportWindows, java.lang.Integer aggregatableReportWindow, org.openqa.selenium.devtools.v142.storage.model.AttributionReportingSourceType type, java.lang.String sourceOrigin, java.lang.String reportingOrigin, java.util.List<java.lang.String> destinationSites, org.openqa.selenium.devtools.v142.storage.model.UnsignedInt64AsBase10 eventId, org.openqa.selenium.devtools.v142.storage.model.SignedInt64AsBase10 priority, java.util.List<org.openqa.selenium.devtools.v142.storage.model.AttributionReportingFilterDataEntry> filterData, java.util.List<org.openqa.selenium.devtools.v142.storage.model.AttributionReportingAggregationKeysEntry> aggregationKeys, java.util.Optional<org.openqa.selenium.devtools.v142.storage.model.UnsignedInt64AsBase10> debugKey, org.openqa.selenium.devtools.v142.storage.model.AttributionReportingTriggerDataMatching triggerDataMatching, org.openqa.selenium.devtools.v142.storage.model.SignedInt64AsBase10 destinationLimitPriority, org.openqa.selenium.devtools.v142.storage.model.AttributionReportingAggregatableDebugReportingConfig aggregatableDebugReportingConfig, java.util.Optional<org.openqa.selenium.devtools.v142.storage.model.AttributionScopesData> scopesData, java.lang.Integer maxEventLevelReports, java.util.List<org.openqa.selenium.devtools.v142.storage.model.AttributionReportingNamedBudgetDef> namedBudgets, java.lang.Boolean debugReporting, java.lang.Number eventLevelEpsilon) {
        this.time = java.util.Objects.requireNonNull(time, "time is required");
        this.expiry = java.util.Objects.requireNonNull(expiry, "expiry is required");
        this.triggerData = java.util.Objects.requireNonNull(triggerData, "triggerData is required");
        this.eventReportWindows = java.util.Objects.requireNonNull(eventReportWindows, "eventReportWindows is required");
        this.aggregatableReportWindow = java.util.Objects.requireNonNull(aggregatableReportWindow, "aggregatableReportWindow is required");
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.sourceOrigin = java.util.Objects.requireNonNull(sourceOrigin, "sourceOrigin is required");
        this.reportingOrigin = java.util.Objects.requireNonNull(reportingOrigin, "reportingOrigin is required");
        this.destinationSites = java.util.Objects.requireNonNull(destinationSites, "destinationSites is required");
        this.eventId = java.util.Objects.requireNonNull(eventId, "eventId is required");
        this.priority = java.util.Objects.requireNonNull(priority, "priority is required");
        this.filterData = java.util.Objects.requireNonNull(filterData, "filterData is required");
        this.aggregationKeys = java.util.Objects.requireNonNull(aggregationKeys, "aggregationKeys is required");
        this.debugKey = debugKey;
        this.triggerDataMatching = java.util.Objects.requireNonNull(triggerDataMatching, "triggerDataMatching is required");
        this.destinationLimitPriority = java.util.Objects.requireNonNull(destinationLimitPriority, "destinationLimitPriority is required");
        this.aggregatableDebugReportingConfig = java.util.Objects.requireNonNull(aggregatableDebugReportingConfig, "aggregatableDebugReportingConfig is required");
        this.scopesData = scopesData;
        this.maxEventLevelReports = java.util.Objects.requireNonNull(maxEventLevelReports, "maxEventLevelReports is required");
        this.namedBudgets = java.util.Objects.requireNonNull(namedBudgets, "namedBudgets is required");
        this.debugReporting = java.util.Objects.requireNonNull(debugReporting, "debugReporting is required");
        this.eventLevelEpsilon = java.util.Objects.requireNonNull(eventLevelEpsilon, "eventLevelEpsilon is required");
    }

    public org.openqa.selenium.devtools.v142.network.model.TimeSinceEpoch getTime() {
        return time;
    }

    /**
     * duration in seconds
     */
    public java.lang.Integer getExpiry() {
        return expiry;
    }

    /**
     * number instead of integer because not all uint32 can be represented by
     * int
     */
    public java.util.List<java.lang.Number> getTriggerData() {
        return triggerData;
    }

    public org.openqa.selenium.devtools.v142.storage.model.AttributionReportingEventReportWindows getEventReportWindows() {
        return eventReportWindows;
    }

    /**
     * duration in seconds
     */
    public java.lang.Integer getAggregatableReportWindow() {
        return aggregatableReportWindow;
    }

    public org.openqa.selenium.devtools.v142.storage.model.AttributionReportingSourceType getType() {
        return type;
    }

    public java.lang.String getSourceOrigin() {
        return sourceOrigin;
    }

    public java.lang.String getReportingOrigin() {
        return reportingOrigin;
    }

    public java.util.List<java.lang.String> getDestinationSites() {
        return destinationSites;
    }

    public org.openqa.selenium.devtools.v142.storage.model.UnsignedInt64AsBase10 getEventId() {
        return eventId;
    }

    public org.openqa.selenium.devtools.v142.storage.model.SignedInt64AsBase10 getPriority() {
        return priority;
    }

    public java.util.List<org.openqa.selenium.devtools.v142.storage.model.AttributionReportingFilterDataEntry> getFilterData() {
        return filterData;
    }

    public java.util.List<org.openqa.selenium.devtools.v142.storage.model.AttributionReportingAggregationKeysEntry> getAggregationKeys() {
        return aggregationKeys;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v142.storage.model.UnsignedInt64AsBase10> getDebugKey() {
        return debugKey;
    }

    public org.openqa.selenium.devtools.v142.storage.model.AttributionReportingTriggerDataMatching getTriggerDataMatching() {
        return triggerDataMatching;
    }

    public org.openqa.selenium.devtools.v142.storage.model.SignedInt64AsBase10 getDestinationLimitPriority() {
        return destinationLimitPriority;
    }

    public org.openqa.selenium.devtools.v142.storage.model.AttributionReportingAggregatableDebugReportingConfig getAggregatableDebugReportingConfig() {
        return aggregatableDebugReportingConfig;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v142.storage.model.AttributionScopesData> getScopesData() {
        return scopesData;
    }

    public java.lang.Integer getMaxEventLevelReports() {
        return maxEventLevelReports;
    }

    public java.util.List<org.openqa.selenium.devtools.v142.storage.model.AttributionReportingNamedBudgetDef> getNamedBudgets() {
        return namedBudgets;
    }

    public java.lang.Boolean getDebugReporting() {
        return debugReporting;
    }

    public java.lang.Number getEventLevelEpsilon() {
        return eventLevelEpsilon;
    }

    private static AttributionReportingSourceRegistration fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v142.network.model.TimeSinceEpoch time = null;
        java.lang.Integer expiry = 0;
        java.util.List<java.lang.Number> triggerData = null;
        org.openqa.selenium.devtools.v142.storage.model.AttributionReportingEventReportWindows eventReportWindows = null;
        java.lang.Integer aggregatableReportWindow = 0;
        org.openqa.selenium.devtools.v142.storage.model.AttributionReportingSourceType type = null;
        java.lang.String sourceOrigin = null;
        java.lang.String reportingOrigin = null;
        java.util.List<java.lang.String> destinationSites = null;
        org.openqa.selenium.devtools.v142.storage.model.UnsignedInt64AsBase10 eventId = null;
        org.openqa.selenium.devtools.v142.storage.model.SignedInt64AsBase10 priority = null;
        java.util.List<org.openqa.selenium.devtools.v142.storage.model.AttributionReportingFilterDataEntry> filterData = null;
        java.util.List<org.openqa.selenium.devtools.v142.storage.model.AttributionReportingAggregationKeysEntry> aggregationKeys = null;
        java.util.Optional<org.openqa.selenium.devtools.v142.storage.model.UnsignedInt64AsBase10> debugKey = java.util.Optional.empty();
        org.openqa.selenium.devtools.v142.storage.model.AttributionReportingTriggerDataMatching triggerDataMatching = null;
        org.openqa.selenium.devtools.v142.storage.model.SignedInt64AsBase10 destinationLimitPriority = null;
        org.openqa.selenium.devtools.v142.storage.model.AttributionReportingAggregatableDebugReportingConfig aggregatableDebugReportingConfig = null;
        java.util.Optional<org.openqa.selenium.devtools.v142.storage.model.AttributionScopesData> scopesData = java.util.Optional.empty();
        java.lang.Integer maxEventLevelReports = 0;
        java.util.List<org.openqa.selenium.devtools.v142.storage.model.AttributionReportingNamedBudgetDef> namedBudgets = null;
        java.lang.Boolean debugReporting = false;
        java.lang.Number eventLevelEpsilon = 0;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "time":
                    time = input.read(org.openqa.selenium.devtools.v142.network.model.TimeSinceEpoch.class);
                    break;
                case "expiry":
                    expiry = input.nextNumber().intValue();
                    break;
                case "triggerData":
                    triggerData = input.readArray(java.lang.Number.class);
                    break;
                case "eventReportWindows":
                    eventReportWindows = input.read(org.openqa.selenium.devtools.v142.storage.model.AttributionReportingEventReportWindows.class);
                    break;
                case "aggregatableReportWindow":
                    aggregatableReportWindow = input.nextNumber().intValue();
                    break;
                case "type":
                    type = input.read(org.openqa.selenium.devtools.v142.storage.model.AttributionReportingSourceType.class);
                    break;
                case "sourceOrigin":
                    sourceOrigin = input.nextString();
                    break;
                case "reportingOrigin":
                    reportingOrigin = input.nextString();
                    break;
                case "destinationSites":
                    destinationSites = input.readArray(java.lang.String.class);
                    break;
                case "eventId":
                    eventId = input.read(org.openqa.selenium.devtools.v142.storage.model.UnsignedInt64AsBase10.class);
                    break;
                case "priority":
                    priority = input.read(org.openqa.selenium.devtools.v142.storage.model.SignedInt64AsBase10.class);
                    break;
                case "filterData":
                    filterData = input.readArray(org.openqa.selenium.devtools.v142.storage.model.AttributionReportingFilterDataEntry.class);
                    break;
                case "aggregationKeys":
                    aggregationKeys = input.readArray(org.openqa.selenium.devtools.v142.storage.model.AttributionReportingAggregationKeysEntry.class);
                    break;
                case "debugKey":
                    debugKey = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v142.storage.model.UnsignedInt64AsBase10.class));
                    break;
                case "triggerDataMatching":
                    triggerDataMatching = input.read(org.openqa.selenium.devtools.v142.storage.model.AttributionReportingTriggerDataMatching.class);
                    break;
                case "destinationLimitPriority":
                    destinationLimitPriority = input.read(org.openqa.selenium.devtools.v142.storage.model.SignedInt64AsBase10.class);
                    break;
                case "aggregatableDebugReportingConfig":
                    aggregatableDebugReportingConfig = input.read(org.openqa.selenium.devtools.v142.storage.model.AttributionReportingAggregatableDebugReportingConfig.class);
                    break;
                case "scopesData":
                    scopesData = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v142.storage.model.AttributionScopesData.class));
                    break;
                case "maxEventLevelReports":
                    maxEventLevelReports = input.nextNumber().intValue();
                    break;
                case "namedBudgets":
                    namedBudgets = input.readArray(org.openqa.selenium.devtools.v142.storage.model.AttributionReportingNamedBudgetDef.class);
                    break;
                case "debugReporting":
                    debugReporting = input.nextBoolean();
                    break;
                case "eventLevelEpsilon":
                    eventLevelEpsilon = input.nextNumber();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AttributionReportingSourceRegistration(time, expiry, triggerData, eventReportWindows, aggregatableReportWindow, type, sourceOrigin, reportingOrigin, destinationSites, eventId, priority, filterData, aggregationKeys, debugKey, triggerDataMatching, destinationLimitPriority, aggregatableDebugReportingConfig, scopesData, maxEventLevelReports, namedBudgets, debugReporting, eventLevelEpsilon);
    }
}
