package org.openqa.selenium.devtools.v142.tracing.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Details exposed when memory request explicitly declared.
 * Keep consistent with memory_dump_request_args.h and
 * memory_instrumentation.mojom
 */
@org.openqa.selenium.Beta()
public enum MemoryDumpLevelOfDetail {

    BACKGROUND("background"), LIGHT("light"), DETAILED("detailed");

    private String value;

    MemoryDumpLevelOfDetail(String value) {
        this.value = value;
    }

    public static MemoryDumpLevelOfDetail fromString(String s) {
        return java.util.Arrays.stream(MemoryDumpLevelOfDetail.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within MemoryDumpLevelOfDetail "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static MemoryDumpLevelOfDetail fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
