/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.virtualauthenticator;

import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.internal.Require;

@NullMarked
public class Credential {
    private final byte[] id;
    private final boolean isResidentCredential;
    private final @Nullable String rpId;
    private final PKCS8EncodedKeySpec privateKey;
    private final byte @Nullable [] userHandle;
    private final int signCount;

    public static Credential createNonResidentCredential(byte[] id, String rpId, PKCS8EncodedKeySpec privateKey, int signCount) {
        return new Credential(id, false, Require.nonNull("rpId", rpId), privateKey, null, signCount);
    }

    public static Credential createResidentCredential(byte[] id, String rpId, PKCS8EncodedKeySpec privateKey, byte[] userHandle, int signCount) {
        return new Credential(id, true, Require.nonNull("rpId", rpId), privateKey, Require.nonNull("User handle", userHandle), signCount);
    }

    public static Credential fromMap(Map<String, Object> map) {
        Object credentialId = Require.nonNull("credentialId", map.get("credentialId"));
        Object isResidentCredential = Require.nonNull("isResidentCredential", map.get("isResidentCredential"));
        Object rpId = map.get("rpId");
        Object privateKey = Require.nonNull("privateKey", map.get("privateKey"));
        Object userHandle = map.get("userHandle");
        Object signCount = Require.nonNull("signCount", map.get("signCount"));
        Base64.Decoder decoder = Base64.getUrlDecoder();
        return new Credential(decoder.decode((String)credentialId), (Boolean)isResidentCredential, (String)rpId, new PKCS8EncodedKeySpec(decoder.decode((String)privateKey)), userHandle == null ? null : decoder.decode((String)userHandle), ((Long)signCount).intValue());
    }

    private Credential(byte[] id, boolean isResidentCredential, @Nullable String rpId, PKCS8EncodedKeySpec privateKey, byte @Nullable [] userHandle, int signCount) {
        this.id = Require.nonNull("Id", id);
        this.isResidentCredential = isResidentCredential;
        this.rpId = rpId;
        this.privateKey = Require.nonNull("Private key", privateKey);
        this.userHandle = userHandle;
        this.signCount = signCount;
    }

    public byte[] getId() {
        return Arrays.copyOf(this.id, this.id.length);
    }

    public boolean isResidentCredential() {
        return this.isResidentCredential;
    }

    public @Nullable String getRpId() {
        return this.rpId;
    }

    public PKCS8EncodedKeySpec getPrivateKey() {
        return this.privateKey;
    }

    public byte @Nullable [] getUserHandle() {
        return this.userHandle == null ? null : Arrays.copyOf(this.userHandle, this.userHandle.length);
    }

    public int getSignCount() {
        return this.signCount;
    }

    public Map<String, @Nullable Object> toMap() {
        Base64.Encoder encoder = Base64.getUrlEncoder();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("credentialId", encoder.encodeToString(this.id));
        map.put("isResidentCredential", this.isResidentCredential);
        map.put("rpId", this.rpId);
        map.put("privateKey", encoder.encodeToString(this.privateKey.getEncoded()));
        map.put("signCount", this.signCount);
        if (this.userHandle != null) {
            map.put("userHandle", encoder.encodeToString(this.userHandle));
        }
        return Collections.unmodifiableMap(map);
    }
}

