/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v144.audits.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v144.audits.model.PermissionElementIssueType;
import org.openqa.selenium.devtools.v144.dom.model.BackendNodeId;
import org.openqa.selenium.json.JsonInput;

public class PermissionElementIssueDetails {
    private final PermissionElementIssueType issueType;
    private final Optional<String> type;
    private final Optional<BackendNodeId> nodeId;
    private final Optional<Boolean> isWarning;
    private final Optional<String> permissionName;
    private final Optional<String> occluderNodeInfo;
    private final Optional<String> occluderParentNodeInfo;
    private final Optional<String> disableReason;

    public PermissionElementIssueDetails(PermissionElementIssueType issueType, Optional<String> type, Optional<BackendNodeId> nodeId, Optional<Boolean> isWarning, Optional<String> permissionName, Optional<String> occluderNodeInfo, Optional<String> occluderParentNodeInfo, Optional<String> disableReason) {
        this.issueType = Objects.requireNonNull(issueType, "issueType is required");
        this.type = type;
        this.nodeId = nodeId;
        this.isWarning = isWarning;
        this.permissionName = permissionName;
        this.occluderNodeInfo = occluderNodeInfo;
        this.occluderParentNodeInfo = occluderParentNodeInfo;
        this.disableReason = disableReason;
    }

    public PermissionElementIssueType getIssueType() {
        return this.issueType;
    }

    public Optional<String> getType() {
        return this.type;
    }

    public Optional<BackendNodeId> getNodeId() {
        return this.nodeId;
    }

    public Optional<Boolean> getIsWarning() {
        return this.isWarning;
    }

    public Optional<String> getPermissionName() {
        return this.permissionName;
    }

    public Optional<String> getOccluderNodeInfo() {
        return this.occluderNodeInfo;
    }

    public Optional<String> getOccluderParentNodeInfo() {
        return this.occluderParentNodeInfo;
    }

    public Optional<String> getDisableReason() {
        return this.disableReason;
    }

    private static PermissionElementIssueDetails fromJson(JsonInput input) {
        PermissionElementIssueType issueType = null;
        Optional<String> type = Optional.empty();
        Optional<BackendNodeId> nodeId = Optional.empty();
        Optional<Boolean> isWarning = Optional.empty();
        Optional<String> permissionName = Optional.empty();
        Optional<String> occluderNodeInfo = Optional.empty();
        Optional<String> occluderParentNodeInfo = Optional.empty();
        Optional<String> disableReason = Optional.empty();
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "issueType": {
                    issueType = (PermissionElementIssueType)((Object)input.read(PermissionElementIssueType.class));
                    continue block20;
                }
                case "type": {
                    type = Optional.ofNullable(input.nextString());
                    continue block20;
                }
                case "nodeId": {
                    nodeId = Optional.ofNullable((BackendNodeId)input.read(BackendNodeId.class));
                    continue block20;
                }
                case "isWarning": {
                    isWarning = Optional.ofNullable(input.nextBoolean());
                    continue block20;
                }
                case "permissionName": {
                    permissionName = Optional.ofNullable(input.nextString());
                    continue block20;
                }
                case "occluderNodeInfo": {
                    occluderNodeInfo = Optional.ofNullable(input.nextString());
                    continue block20;
                }
                case "occluderParentNodeInfo": {
                    occluderParentNodeInfo = Optional.ofNullable(input.nextString());
                    continue block20;
                }
                case "disableReason": {
                    disableReason = Optional.ofNullable(input.nextString());
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PermissionElementIssueDetails(issueType, type, nodeId, isWarning, permissionName, occluderNodeInfo, occluderParentNodeInfo, disableReason);
    }
}

