/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v144.extensions;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.v144.extensions.model.StorageArea;

@Beta
public class Extensions {
    public static Command<String> loadUnpacked(String path) {
        Objects.requireNonNull(path, "path is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("path", path);
        return new Command("Extensions.loadUnpacked", Map.copyOf(params), ConverterFunctions.map((String)"id", String.class));
    }

    public static Command<Void> uninstall(String id) {
        Objects.requireNonNull(id, "id is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("id", id);
        return new Command("Extensions.uninstall", Map.copyOf(params));
    }

    public static Command<Map<String, Object>> getStorageItems(String id, StorageArea storageArea, Optional<List<String>> keys) {
        Objects.requireNonNull(id, "id is required");
        Objects.requireNonNull(storageArea, "storageArea is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("id", id);
        params.put("storageArea", (Object)storageArea);
        keys.ifPresent(p -> params.put("keys", p));
        return new Command("Extensions.getStorageItems", Map.copyOf(params), ConverterFunctions.map((String)"data", Map.class));
    }

    public static Command<Void> removeStorageItems(String id, StorageArea storageArea, List<String> keys) {
        Objects.requireNonNull(id, "id is required");
        Objects.requireNonNull(storageArea, "storageArea is required");
        Objects.requireNonNull(keys, "keys is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("id", id);
        params.put("storageArea", (Object)storageArea);
        params.put("keys", keys);
        return new Command("Extensions.removeStorageItems", Map.copyOf(params));
    }

    public static Command<Void> clearStorageItems(String id, StorageArea storageArea) {
        Objects.requireNonNull(id, "id is required");
        Objects.requireNonNull(storageArea, "storageArea is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("id", id);
        params.put("storageArea", (Object)storageArea);
        return new Command("Extensions.clearStorageItems", Map.copyOf(params));
    }

    public static Command<Void> setStorageItems(String id, StorageArea storageArea, Map<String, Object> values) {
        Objects.requireNonNull(id, "id is required");
        Objects.requireNonNull(storageArea, "storageArea is required");
        Objects.requireNonNull(values, "values is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("id", id);
        params.put("storageArea", (Object)storageArea);
        params.put("values", values);
        return new Command("Extensions.setStorageItems", Map.copyOf(params));
    }
}

