/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.function.IOUnaryOperator;
import org.apache.commons.io.function.TestConstants;
import org.apache.commons.io.function.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IOUnaryOperatorTest {
    IOUnaryOperatorTest() {
    }

    @Test
    void testAsUnaryOperator() {
        List<Path> list = Arrays.asList(TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_A);
        IOUnaryOperator throwingIOUnaryOperator = TestUtils.throwingIOUnaryOperator();
        Assertions.assertThrows(UncheckedIOException.class, () -> list.replaceAll(throwingIOUnaryOperator.asUnaryOperator()));
        Assertions.assertEquals((Object)"a", Optional.of("a").map(IOUnaryOperator.identity().asUnaryOperator()).get());
        Assertions.assertEquals((Object)"a", Optional.of("a").map(IOUnaryOperator.identity().asFunction()).get());
    }

    @Test
    void testIdentity() throws IOException {
        Assertions.assertEquals((Object)IOUnaryOperator.identity(), (Object)IOUnaryOperator.identity());
        IOUnaryOperator identityFunction = IOUnaryOperator.identity();
        byte[] buf = new byte[]{10, 11, 12};
        Assertions.assertEquals((Object)buf, (Object)identityFunction.apply((Object)buf));
        Assertions.assertArrayEquals((byte[])buf, (byte[])((byte[])identityFunction.apply((Object)buf)));
    }
}

