/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.language.Comment;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.IgnoredChars;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.NodeChildrenContainer;
import graphql.language.NodeDirectivesBuilder;
import graphql.language.SDLExtensionDefinition;
import graphql.language.SourceLocation;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class InputObjectTypeExtensionDefinition
extends InputObjectTypeDefinition
implements SDLExtensionDefinition {
    @Internal
    protected InputObjectTypeExtensionDefinition(String name, List<Directive> directives, List<InputValueDefinition> inputValueDefinitions, Description description, SourceLocation sourceLocation, List<Comment> comments, IgnoredChars ignoredChars, Map<String, String> additionalData) {
        super(name, directives, inputValueDefinitions, description, sourceLocation, comments, ignoredChars, additionalData);
    }

    @Override
    public InputObjectTypeExtensionDefinition deepCopy() {
        return new InputObjectTypeExtensionDefinition(this.getName(), this.deepCopy(this.getDirectives()), this.deepCopy(this.getInputValueDefinitions()), this.getDescription(), this.getSourceLocation(), this.getComments(), this.getIgnoredChars(), this.getAdditionalData());
    }

    @Override
    public String toString() {
        return "InputObjectTypeExtensionDefinition{name='" + this.getName() + "', directives=" + String.valueOf(this.getDirectives()) + ", inputValueDefinitions=" + String.valueOf(this.getInputValueDefinitions()) + "}";
    }

    public static Builder newInputObjectTypeExtensionDefinition() {
        return new Builder();
    }

    @Override
    public InputObjectTypeExtensionDefinition withNewChildren(NodeChildrenContainer newChildren) {
        return this.transformExtension(builder -> ((Builder)builder.directives(newChildren.getChildren("directives"))).inputValueDefinitions(newChildren.getChildren("inputValueDefinitions")));
    }

    public InputObjectTypeExtensionDefinition transformExtension(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeDirectivesBuilder {
        private SourceLocation sourceLocation;
        private ImmutableList<Comment> comments = ImmutableKit.emptyList();
        private String name;
        private Description description;
        private ImmutableList<Directive> directives = ImmutableKit.emptyList();
        private ImmutableList<InputValueDefinition> inputValueDefinitions = ImmutableKit.emptyList();
        private IgnoredChars ignoredChars = IgnoredChars.EMPTY;
        private Map<String, String> additionalData = new LinkedHashMap<String, String>();

        private Builder() {
        }

        private Builder(InputObjectTypeDefinition existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = ImmutableList.copyOf(existing.getComments());
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.directives = ImmutableList.copyOf(existing.getDirectives());
            this.inputValueDefinitions = ImmutableList.copyOf(existing.getInputValueDefinitions());
            this.ignoredChars = existing.getIgnoredChars();
            this.additionalData = new LinkedHashMap<String, String>(existing.getAdditionalData());
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = ImmutableList.copyOf(comments);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(Description description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder directives(List<Directive> directives) {
            this.directives = ImmutableList.copyOf(directives);
            return this;
        }

        @Override
        public Builder directive(Directive directive) {
            this.directives = ImmutableKit.addToList(this.directives, directive, new Directive[0]);
            return this;
        }

        public Builder inputValueDefinitions(List<InputValueDefinition> inputValueDefinitions) {
            this.inputValueDefinitions = ImmutableList.copyOf(inputValueDefinitions);
            return this;
        }

        public Builder inputValueDefinition(InputValueDefinition inputValueDefinition) {
            this.inputValueDefinitions = ImmutableKit.addToList(this.inputValueDefinitions, inputValueDefinition, new InputValueDefinition[0]);
            return this;
        }

        @Override
        public Builder ignoredChars(IgnoredChars ignoredChars) {
            this.ignoredChars = ignoredChars;
            return this;
        }

        @Override
        public Builder additionalData(Map<String, String> additionalData) {
            this.additionalData = Assert.assertNotNull(additionalData);
            return this;
        }

        @Override
        public Builder additionalData(String key, String value) {
            this.additionalData.put(key, value);
            return this;
        }

        public InputObjectTypeExtensionDefinition build() {
            InputObjectTypeExtensionDefinition inputObjectTypeDefinition = new InputObjectTypeExtensionDefinition(this.name, this.directives, this.inputValueDefinitions, this.description, this.sourceLocation, this.comments, this.ignoredChars, this.additionalData);
            return inputObjectTypeDefinition;
        }
    }
}

