/*
 * Decompiled with CFR 0.152.
 */
package graphql.normalized;

import graphql.Assert;
import graphql.Directives;
import graphql.ExperimentalApi;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.execution.directives.QueryAppliedDirective;
import graphql.execution.directives.QueryDirectives;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.InlineFragment;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.StringValue;
import graphql.language.TypeName;
import graphql.normalized.ArgumentMaker;
import graphql.normalized.ExecutableNormalizedField;
import graphql.normalized.VariableAccumulator;
import graphql.normalized.VariablePredicate;
import graphql.normalized.incremental.NormalizedDeferredExecution;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnmodifiedType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@PublicApi
public class ExecutableNormalizedOperationToAstCompiler {
    public static CompilerResult compileToDocument(@NonNull GraphQLSchema schema, @NonNull OperationDefinition.Operation operationKind, @Nullable String operationName, @NonNull List<ExecutableNormalizedField> topLevelFields, @Nullable VariablePredicate variablePredicate) {
        return ExecutableNormalizedOperationToAstCompiler.compileToDocument(schema, operationKind, operationName, topLevelFields, Map.of(), variablePredicate);
    }

    public static CompilerResult compileToDocument(@NonNull GraphQLSchema schema, @NonNull OperationDefinition.Operation operationKind, @Nullable String operationName, @NonNull List<ExecutableNormalizedField> topLevelFields, @NonNull Map<ExecutableNormalizedField, QueryDirectives> normalizedFieldToQueryDirectives, @Nullable VariablePredicate variablePredicate) {
        return ExecutableNormalizedOperationToAstCompiler.compileToDocument(schema, operationKind, operationName, topLevelFields, normalizedFieldToQueryDirectives, variablePredicate, false);
    }

    @ExperimentalApi
    public static CompilerResult compileToDocumentWithDeferSupport(@NonNull GraphQLSchema schema, @NonNull OperationDefinition.Operation operationKind, @Nullable String operationName, @NonNull List<ExecutableNormalizedField> topLevelFields, @Nullable VariablePredicate variablePredicate) {
        return ExecutableNormalizedOperationToAstCompiler.compileToDocumentWithDeferSupport(schema, operationKind, operationName, topLevelFields, Map.of(), variablePredicate);
    }

    @ExperimentalApi
    public static CompilerResult compileToDocumentWithDeferSupport(@NonNull GraphQLSchema schema, @NonNull OperationDefinition.Operation operationKind, @Nullable String operationName, @NonNull List<ExecutableNormalizedField> topLevelFields, @NonNull Map<ExecutableNormalizedField, QueryDirectives> normalizedFieldToQueryDirectives, @Nullable VariablePredicate variablePredicate) {
        return ExecutableNormalizedOperationToAstCompiler.compileToDocument(schema, operationKind, operationName, topLevelFields, normalizedFieldToQueryDirectives, variablePredicate, true);
    }

    private static CompilerResult compileToDocument(@NonNull GraphQLSchema schema, @NonNull OperationDefinition.Operation operationKind, @Nullable String operationName, @NonNull List<ExecutableNormalizedField> topLevelFields, @NonNull Map<ExecutableNormalizedField, QueryDirectives> normalizedFieldToQueryDirectives, @Nullable VariablePredicate variablePredicate, boolean deferSupport) {
        GraphQLObjectType operationType = ExecutableNormalizedOperationToAstCompiler.getOperationType(schema, operationKind);
        VariableAccumulator variableAccumulator = new VariableAccumulator(variablePredicate);
        List<Selection<?>> selections = ExecutableNormalizedOperationToAstCompiler.subselectionsForNormalizedField(schema, operationType.getName(), topLevelFields, normalizedFieldToQueryDirectives, variableAccumulator, deferSupport);
        SelectionSet selectionSet = new SelectionSet(selections);
        OperationDefinition.Builder definitionBuilder = OperationDefinition.newOperationDefinition().name(operationName).operation(operationKind).selectionSet(selectionSet);
        definitionBuilder.variableDefinitions(variableAccumulator.getVariableDefinitions());
        return new CompilerResult(Document.newDocument().definition(definitionBuilder.build()).build(), variableAccumulator.getVariablesMap());
    }

    private static List<Selection<?>> subselectionsForNormalizedField(GraphQLSchema schema, @NonNull String parentOutputType, List<ExecutableNormalizedField> executableNormalizedFields, @NonNull Map<ExecutableNormalizedField, QueryDirectives> normalizedFieldToQueryDirectives, VariableAccumulator variableAccumulator, boolean deferSupport) {
        if (deferSupport) {
            return ExecutableNormalizedOperationToAstCompiler.subselectionsForNormalizedFieldWithDeferSupport(schema, parentOutputType, executableNormalizedFields, normalizedFieldToQueryDirectives, variableAccumulator);
        }
        return ExecutableNormalizedOperationToAstCompiler.subselectionsForNormalizedFieldNoDeferSupport(schema, parentOutputType, executableNormalizedFields, normalizedFieldToQueryDirectives, variableAccumulator);
    }

    private static List<Selection<?>> subselectionsForNormalizedFieldNoDeferSupport(GraphQLSchema schema, @NonNull String parentOutputType, List<ExecutableNormalizedField> executableNormalizedFields, @NonNull Map<ExecutableNormalizedField, QueryDirectives> normalizedFieldToQueryDirectives, VariableAccumulator variableAccumulator) {
        ImmutableList.Builder selections = ImmutableList.builder();
        LinkedHashMap<String, List> fieldsByTypeCondition = new LinkedHashMap<String, List>();
        for (ExecutableNormalizedField nf : executableNormalizedFields) {
            if (nf.isConditional(schema)) {
                ExecutableNormalizedOperationToAstCompiler.selectionForNormalizedField(schema, nf, normalizedFieldToQueryDirectives, variableAccumulator, false).forEach((objectTypeName, field) -> fieldsByTypeCondition.computeIfAbsent((String)objectTypeName, ignored -> new ArrayList()).add(field));
                continue;
            }
            selections.add(ExecutableNormalizedOperationToAstCompiler.selectionForNormalizedField(schema, parentOutputType, nf, normalizedFieldToQueryDirectives, variableAccumulator, false));
        }
        fieldsByTypeCondition.forEach((objectTypeName, fields) -> {
            TypeName typeName = TypeName.newTypeName(objectTypeName).build();
            InlineFragment inlineFragment = InlineFragment.newInlineFragment().typeCondition(typeName).selectionSet(ExecutableNormalizedOperationToAstCompiler.selectionSet(fields)).build();
            selections.add(inlineFragment);
        });
        return selections.build();
    }

    private static List<Selection<?>> subselectionsForNormalizedFieldWithDeferSupport(GraphQLSchema schema, @NonNull String parentOutputType, List<ExecutableNormalizedField> executableNormalizedFields, @NonNull Map<ExecutableNormalizedField, QueryDirectives> normalizedFieldToQueryDirectives, VariableAccumulator variableAccumulator) {
        ImmutableList.Builder selections = ImmutableList.builder();
        LinkedHashMap<ExecutionFragmentDetails, List> fieldsByFragmentDetails = new LinkedHashMap<ExecutionFragmentDetails, List>();
        for (ExecutableNormalizedField nf : executableNormalizedFields) {
            LinkedHashSet<NormalizedDeferredExecution> deferredExecutions = nf.getDeferredExecutions();
            if (nf.isConditional(schema)) {
                ExecutableNormalizedOperationToAstCompiler.selectionForNormalizedField(schema, nf, normalizedFieldToQueryDirectives, variableAccumulator, true).forEach((objectTypeName, field) -> {
                    if (deferredExecutions == null || deferredExecutions.isEmpty()) {
                        fieldsByFragmentDetails.computeIfAbsent(new ExecutionFragmentDetails((String)objectTypeName, null), ignored -> new ArrayList()).add(field);
                    } else {
                        deferredExecutions.forEach(deferredExecution -> fieldsByFragmentDetails.computeIfAbsent(new ExecutionFragmentDetails((String)objectTypeName, (NormalizedDeferredExecution)deferredExecution), ignored -> new ArrayList()).add(field));
                    }
                });
                continue;
            }
            if (deferredExecutions != null && !deferredExecutions.isEmpty()) {
                Field field2 = ExecutableNormalizedOperationToAstCompiler.selectionForNormalizedField(schema, parentOutputType, nf, normalizedFieldToQueryDirectives, variableAccumulator, true);
                deferredExecutions.forEach(deferredExecution -> fieldsByFragmentDetails.computeIfAbsent(new ExecutionFragmentDetails(null, (NormalizedDeferredExecution)deferredExecution), ignored -> new ArrayList()).add(field2));
                continue;
            }
            selections.add(ExecutableNormalizedOperationToAstCompiler.selectionForNormalizedField(schema, parentOutputType, nf, normalizedFieldToQueryDirectives, variableAccumulator, true));
        }
        fieldsByFragmentDetails.forEach((typeAndDeferPair, fields) -> {
            InlineFragment.Builder fragmentBuilder = InlineFragment.newInlineFragment().selectionSet(ExecutableNormalizedOperationToAstCompiler.selectionSet(fields));
            if (typeAndDeferPair.typeName != null) {
                TypeName typeName = TypeName.newTypeName(typeAndDeferPair.typeName).build();
                fragmentBuilder.typeCondition(typeName);
            }
            if (typeAndDeferPair.deferredExecution != null) {
                Directive.Builder deferBuilder = Directive.newDirective().name(Directives.DeferDirective.getName());
                if (typeAndDeferPair.deferredExecution.getLabel() != null) {
                    deferBuilder.argument(Argument.newArgument().name("label").value(StringValue.of(typeAndDeferPair.deferredExecution.getLabel())).build());
                }
                fragmentBuilder.directive(deferBuilder.build());
            }
            selections.add(fragmentBuilder.build());
        });
        return selections.build();
    }

    private static Map<String, Field> selectionForNormalizedField(GraphQLSchema schema, ExecutableNormalizedField executableNormalizedField, @NonNull Map<ExecutableNormalizedField, QueryDirectives> normalizedFieldToQueryDirectives, VariableAccumulator variableAccumulator, boolean deferSupport) {
        LinkedHashMap<String, Field> groupedFields = new LinkedHashMap<String, Field>();
        for (String objectTypeName : executableNormalizedField.getObjectTypeNames()) {
            groupedFields.put(objectTypeName, ExecutableNormalizedOperationToAstCompiler.selectionForNormalizedField(schema, objectTypeName, executableNormalizedField, normalizedFieldToQueryDirectives, variableAccumulator, deferSupport));
        }
        return groupedFields;
    }

    private static Field selectionForNormalizedField(GraphQLSchema schema, String objectTypeName, ExecutableNormalizedField executableNormalizedField, @NonNull Map<ExecutableNormalizedField, QueryDirectives> normalizedFieldToQueryDirectives, VariableAccumulator variableAccumulator, boolean deferSupport) {
        List<Selection<?>> subSelections;
        if (executableNormalizedField.getChildren().isEmpty()) {
            subSelections = ImmutableKit.emptyList();
        } else {
            GraphQLFieldDefinition fieldDef = ExecutableNormalizedOperationToAstCompiler.getFieldDefinition(schema, objectTypeName, executableNormalizedField);
            GraphQLUnmodifiedType fieldOutputType = GraphQLTypeUtil.unwrapAll(fieldDef.getType());
            subSelections = ExecutableNormalizedOperationToAstCompiler.subselectionsForNormalizedField(schema, fieldOutputType.getName(), executableNormalizedField.getChildren(), normalizedFieldToQueryDirectives, variableAccumulator, deferSupport);
        }
        SelectionSet selectionSet = ExecutableNormalizedOperationToAstCompiler.selectionSetOrNullIfEmpty(subSelections);
        List<Argument> arguments = ArgumentMaker.createArguments(executableNormalizedField, variableAccumulator);
        QueryDirectives queryDirectives = normalizedFieldToQueryDirectives.get(executableNormalizedField);
        Field.Builder builder = Field.newField().name(executableNormalizedField.getFieldName()).alias(executableNormalizedField.getAlias()).selectionSet(selectionSet).arguments(arguments);
        List<Directive> directives = ExecutableNormalizedOperationToAstCompiler.buildDirectives(executableNormalizedField, queryDirectives, variableAccumulator);
        return ((Field.Builder)builder.directives((List)directives)).build();
    }

    private static @NonNull List<Directive> buildDirectives(ExecutableNormalizedField executableNormalizedField, QueryDirectives queryDirectives, VariableAccumulator variableAccumulator) {
        if (queryDirectives == null || queryDirectives.getImmediateAppliedDirectivesByField().isEmpty()) {
            return ImmutableKit.emptyList();
        }
        return queryDirectives.getImmediateAppliedDirectivesByField().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).map(queryAppliedDirective -> ExecutableNormalizedOperationToAstCompiler.buildDirective(executableNormalizedField, queryDirectives, queryAppliedDirective, variableAccumulator)).collect(Collectors.toList());
    }

    private static Directive buildDirective(ExecutableNormalizedField executableNormalizedField, QueryDirectives queryDirectives, QueryAppliedDirective queryAppliedDirective, VariableAccumulator variableAccumulator) {
        List<Argument> arguments = ArgumentMaker.createDirectiveArguments(executableNormalizedField, queryDirectives, queryAppliedDirective, variableAccumulator);
        return Directive.newDirective().name(queryAppliedDirective.getName()).arguments(arguments).build();
    }

    private static @Nullable SelectionSet selectionSetOrNullIfEmpty(List<Selection<?>> selections) {
        return selections.isEmpty() ? null : SelectionSet.newSelectionSet().selections(selections).build();
    }

    private static SelectionSet selectionSet(List<Field> fields) {
        return SelectionSet.newSelectionSet().selections(fields).build();
    }

    private static @NonNull GraphQLFieldDefinition getFieldDefinition(GraphQLSchema schema, String parentType, ExecutableNormalizedField nf) {
        return Introspection.getFieldDef(schema, (GraphQLCompositeType)schema.getType(parentType), nf.getName());
    }

    private static @Nullable GraphQLObjectType getOperationType(@NonNull GraphQLSchema schema, @NonNull OperationDefinition.Operation operationKind) {
        switch (operationKind) {
            case QUERY: {
                return schema.getQueryType();
            }
            case MUTATION: {
                return schema.getMutationType();
            }
            case SUBSCRIPTION: {
                return schema.getSubscriptionType();
            }
        }
        return (GraphQLObjectType)Assert.assertShouldNeverHappen("Unknown operation kind " + String.valueOf((Object)operationKind), new Object[0]);
    }

    private static class ExecutionFragmentDetails {
        private final String typeName;
        private final NormalizedDeferredExecution deferredExecution;

        public ExecutionFragmentDetails(String typeName, NormalizedDeferredExecution deferredExecution) {
            this.typeName = typeName;
            this.deferredExecution = deferredExecution;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExecutionFragmentDetails that = (ExecutionFragmentDetails)o;
            return Objects.equals(this.typeName, that.typeName) && Objects.equals(this.deferredExecution, that.deferredExecution);
        }

        public int hashCode() {
            return Objects.hash(this.typeName, this.deferredExecution);
        }
    }

    public static class CompilerResult {
        private final Document document;
        private final Map<String, Object> variables;

        public CompilerResult(Document document, Map<String, Object> variables) {
            this.document = document;
            this.variables = variables;
        }

        public Document getDocument() {
            return this.document;
        }

        public Map<String, Object> getVariables() {
            return this.variables;
        }
    }
}

