/*
 * Decompiled with CFR 0.152.
 */
package graphql.normalized.nf;

import graphql.Assert;
import graphql.ExperimentalApi;
import graphql.com.google.common.collect.ImmutableCollection;
import graphql.com.google.common.collect.ImmutableListMultimap;
import graphql.execution.MergedField;
import graphql.execution.ResultPath;
import graphql.execution.directives.QueryDirectives;
import graphql.language.Field;
import graphql.language.OperationDefinition;
import graphql.normalized.nf.NormalizedField;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLFieldsContainer;
import java.util.List;
import java.util.Map;

@ExperimentalApi
public class NormalizedOperation {
    private final OperationDefinition.Operation operation;
    private final String operationName;
    private final List<NormalizedField> rootFields;
    private final ImmutableListMultimap<Field, NormalizedField> fieldToNormalizedField;
    private final Map<NormalizedField, MergedField> normalizedFieldToMergedField;
    private final Map<NormalizedField, QueryDirectives> normalizedFieldToQueryDirectives;
    private final ImmutableListMultimap<FieldCoordinates, NormalizedField> coordinatesToNormalizedFields;
    private final int operationFieldCount;
    private final int operationDepth;

    public NormalizedOperation(OperationDefinition.Operation operation, String operationName, List<NormalizedField> rootFields, ImmutableListMultimap<Field, NormalizedField> fieldToNormalizedField, Map<NormalizedField, MergedField> normalizedFieldToMergedField, Map<NormalizedField, QueryDirectives> normalizedFieldToQueryDirectives, ImmutableListMultimap<FieldCoordinates, NormalizedField> coordinatesToNormalizedFields, int operationFieldCount, int operationDepth) {
        this.operation = operation;
        this.operationName = operationName;
        this.rootFields = rootFields;
        this.fieldToNormalizedField = fieldToNormalizedField;
        this.normalizedFieldToMergedField = normalizedFieldToMergedField;
        this.normalizedFieldToQueryDirectives = normalizedFieldToQueryDirectives;
        this.coordinatesToNormalizedFields = coordinatesToNormalizedFields;
        this.operationFieldCount = operationFieldCount;
        this.operationDepth = operationDepth;
    }

    public OperationDefinition.Operation getOperation() {
        return this.operation;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public int getOperationFieldCount() {
        return this.operationFieldCount;
    }

    public int getOperationDepth() {
        return this.operationDepth;
    }

    public ImmutableListMultimap<FieldCoordinates, NormalizedField> getCoordinatesToNormalizedFields() {
        return this.coordinatesToNormalizedFields;
    }

    public List<NormalizedField> getRootFields() {
        return this.rootFields;
    }

    public ImmutableListMultimap<Field, NormalizedField> getFieldToNormalizedField() {
        return this.fieldToNormalizedField;
    }

    public List<NormalizedField> getNormalizedFields(Field field) {
        return this.fieldToNormalizedField.get((Object)field);
    }

    public Map<NormalizedField, MergedField> getNormalizedFieldToMergedField() {
        return this.normalizedFieldToMergedField;
    }

    public MergedField getMergedField(NormalizedField NormalizedField2) {
        return this.normalizedFieldToMergedField.get(NormalizedField2);
    }

    public Map<NormalizedField, QueryDirectives> getNormalizedFieldToQueryDirectives() {
        return this.normalizedFieldToQueryDirectives;
    }

    public QueryDirectives getQueryDirectives(NormalizedField NormalizedField2) {
        return this.normalizedFieldToQueryDirectives.get(NormalizedField2);
    }

    public NormalizedField getNormalizedField(MergedField mergedField, GraphQLFieldsContainer fieldsContainer, ResultPath resultPath) {
        ImmutableCollection NormalizedFields = this.fieldToNormalizedField.get((Object)mergedField.getSingleField());
        List<String> keysOnlyPath = resultPath.getKeysOnly();
        for (NormalizedField NormalizedField2 : NormalizedFields) {
            if (!NormalizedField2.getListOfResultKeys().equals(keysOnlyPath) || !NormalizedField2.getObjectTypeNames().contains(fieldsContainer.getName())) continue;
            return NormalizedField2;
        }
        return (NormalizedField)Assert.assertShouldNeverHappen("normalized field not found", new Object[0]);
    }
}

