/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphqlTypeComparatorEnvironment;
import graphql.schema.GraphqlTypeComparatorRegistry;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;

@PublicApi
public class DefaultGraphqlTypeComparatorRegistry
implements GraphqlTypeComparatorRegistry {
    private static final ImmutableMap<Class<? extends GraphQLSchemaElement>, Integer> SENSIBLE_ORDER = ImmutableMap.builder().put(GraphQLDirective.class, 1).put(GraphQLInterfaceType.class, 2).put(GraphQLUnionType.class, 3).put(GraphQLObjectType.class, 4).put(GraphQLEnumType.class, 5).put(GraphQLScalarType.class, 6).put(GraphQLInputObjectType.class, 7).build();
    public static final Comparator<GraphQLSchemaElement> DEFAULT_COMPARATOR = DefaultGraphqlTypeComparatorRegistry.sensibleGroupedOrder();
    private Map<GraphqlTypeComparatorEnvironment, Comparator<?>> registry = new HashMap();

    public static Comparator<GraphQLSchemaElement> sensibleGroupedOrder() {
        return (o1, o2) -> {
            int i2;
            o1 = DefaultGraphqlTypeComparatorRegistry.unwrapElement(o1);
            o2 = DefaultGraphqlTypeComparatorRegistry.unwrapElement(o2);
            int i1 = SENSIBLE_ORDER.getOrDefault(o1.getClass(), 0);
            int rc = i1 - (i2 = SENSIBLE_ORDER.getOrDefault(o2.getClass(), 0).intValue());
            if (rc == 0) {
                rc = DefaultGraphqlTypeComparatorRegistry.compareByName(o1, o2);
            }
            return rc;
        };
    }

    private static GraphQLSchemaElement unwrapElement(GraphQLSchemaElement element) {
        if (element instanceof GraphQLType) {
            GraphQLType castElement = (GraphQLType)element;
            castElement = GraphQLTypeUtil.unwrapAllAs(castElement);
            element = castElement;
        }
        return element;
    }

    private static int compareByName(GraphQLSchemaElement o1, GraphQLSchemaElement o2) {
        return Comparator.comparing(element -> {
            if (element instanceof GraphQLType) {
                element = DefaultGraphqlTypeComparatorRegistry.unwrapElement((GraphQLType)element);
            }
            if (element instanceof GraphQLNamedSchemaElement) {
                return ((GraphQLNamedSchemaElement)element).getName();
            }
            return Objects.toString(element);
        }).compare(o1, o2);
    }

    private DefaultGraphqlTypeComparatorRegistry() {
    }

    private DefaultGraphqlTypeComparatorRegistry(Map<GraphqlTypeComparatorEnvironment, Comparator<?>> registry) {
        this.registry = registry;
    }

    @Override
    public <T extends GraphQLSchemaElement> Comparator<? super T> getComparator(GraphqlTypeComparatorEnvironment environment) {
        Comparator<?> comparator = this.registry.get(environment);
        if (comparator != null) {
            return comparator;
        }
        comparator = this.registry.get(environment.transform(builder -> builder.parentType(null)));
        if (comparator != null) {
            return comparator;
        }
        return DEFAULT_COMPARATOR;
    }

    public static GraphqlTypeComparatorRegistry defaultComparators() {
        return new DefaultGraphqlTypeComparatorRegistry();
    }

    public static Builder newComparators() {
        return new Builder();
    }

    public static class Builder {
        private final Map<GraphqlTypeComparatorEnvironment, Comparator<?>> registry = new HashMap();

        public <T extends GraphQLType> Builder addComparator(GraphqlTypeComparatorEnvironment environment, Class<T> comparatorClass, Comparator<? super T> comparator) {
            Assert.assertNotNull(environment, () -> "environment can't be null");
            Assert.assertNotNull(comparatorClass, () -> "comparatorClass can't be null");
            Assert.assertNotNull(comparator, () -> "comparator can't be null");
            this.registry.put(environment, comparator);
            return this;
        }

        public <T extends GraphQLType> Builder addComparator(UnaryOperator<GraphqlTypeComparatorEnvironment.Builder> builderFunction, Class<T> comparatorClass, Comparator<? super T> comparator) {
            Assert.assertNotNull(builderFunction, () -> "builderFunction can't be null");
            GraphqlTypeComparatorEnvironment environment = ((GraphqlTypeComparatorEnvironment.Builder)builderFunction.apply(GraphqlTypeComparatorEnvironment.newEnvironment())).build();
            return this.addComparator(environment, comparatorClass, comparator);
        }

        public DefaultGraphqlTypeComparatorRegistry build() {
            return new DefaultGraphqlTypeComparatorRegistry(this.registry);
        }
    }
}

