/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactory;
import graphql.schema.DataFetcherFactoryEnvironment;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.LightDataFetcher;
import graphql.schema.PropertyDataFetcherHelper;
import java.util.function.Supplier;

public class SingletonPropertyDataFetcher<T>
implements LightDataFetcher<T> {
    private static final SingletonPropertyDataFetcher<Object> SINGLETON_FETCHER = new SingletonPropertyDataFetcher();
    private static final DataFetcherFactory<?> SINGLETON_FETCHER_FACTORY = new DataFetcherFactory<Object>(){

        @Override
        public DataFetcher<Object> get(DataFetcherFactoryEnvironment environment) {
            return SINGLETON_FETCHER;
        }

        @Override
        public DataFetcher<Object> get(GraphQLFieldDefinition fieldDefinition) {
            return SINGLETON_FETCHER;
        }
    };

    public static LightDataFetcher<?> singleton() {
        return SINGLETON_FETCHER;
    }

    public static DataFetcherFactory<?> singletonFactory() {
        return SINGLETON_FETCHER_FACTORY;
    }

    private SingletonPropertyDataFetcher() {
    }

    @Override
    public T get(GraphQLFieldDefinition fieldDefinition, Object sourceObject, Supplier<DataFetchingEnvironment> environmentSupplier) throws Exception {
        return this.fetchImpl(fieldDefinition, sourceObject, environmentSupplier);
    }

    @Override
    public T get(DataFetchingEnvironment environment) throws Exception {
        return this.fetchImpl(environment.getFieldDefinition(), environment.getSource(), () -> environment);
    }

    private T fetchImpl(GraphQLFieldDefinition fieldDefinition, Object source, Supplier<DataFetchingEnvironment> environmentSupplier) {
        if (source == null) {
            return null;
        }
        return (T)PropertyDataFetcherHelper.getPropertyValue(fieldDefinition.getName(), source, fieldDefinition.getType(), environmentSupplier);
    }
}

