/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.browser;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SetDownloadBehaviorParameters {
    private final Map<String, Object> map = new HashMap<String, Object>();

    public SetDownloadBehaviorParameters(Boolean allowed, String destinationFolder) {
        this(allowed, destinationFolder != null ? Paths.get(destinationFolder, new String[0]) : null);
    }

    public SetDownloadBehaviorParameters(Boolean allowed, Path destinationFolder) {
        if (allowed == null) {
            this.map.put("downloadBehavior", null);
        } else if (allowed.booleanValue()) {
            if (destinationFolder == null) {
                throw new IllegalArgumentException("destinationFolder is required when allowed is true");
            }
            HashMap<String, String> behavior = new HashMap<String, String>();
            behavior.put("type", "allowed");
            behavior.put("destinationFolder", destinationFolder.toAbsolutePath().toString());
            this.map.put("downloadBehavior", behavior);
        } else {
            if (destinationFolder != null) {
                throw new IllegalArgumentException("destinationFolder should not be provided when allowed is false");
            }
            HashMap<String, String> behavior = new HashMap<String, String>();
            behavior.put("type", "denied");
            this.map.put("downloadBehavior", behavior);
        }
    }

    public SetDownloadBehaviorParameters userContexts(List<String> userContexts) {
        this.map.put("userContexts", userContexts);
        return this;
    }

    public Map<String, Object> toMap() {
        return this.map;
    }
}

