/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools;

import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Connection;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.idealized.Domains;
import org.openqa.selenium.devtools.idealized.target.model.SessionID;
import org.openqa.selenium.devtools.idealized.target.model.TargetID;
import org.openqa.selenium.devtools.idealized.target.model.TargetInfo;
import org.openqa.selenium.internal.Require;

public class DevTools
implements Closeable {
    private static final Logger LOG = Logger.getLogger(DevTools.class.getName());
    private final Domains protocol;
    private final Duration timeout = Duration.ofSeconds(30L);
    private final Connection connection;
    private volatile String windowHandle;
    private volatile SessionID cdpSession;

    public DevTools(Function<DevTools, Domains> protocol, Connection connection) {
        this.connection = Require.nonNull("WebSocket connection", connection);
        this.protocol = Require.nonNull("CDP protocol", protocol).apply(this);
    }

    public Domains getDomains() {
        return this.protocol;
    }

    @Override
    public void close() {
        this.disconnectSession();
        this.connection.close();
    }

    public void disconnectSession() {
        if (this.cdpSession != null) {
            try {
                this.getDomains().network().disable();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Exception while disabling network", e);
            }
            SessionID id = this.cdpSession;
            this.cdpSession = null;
            this.windowHandle = null;
            try {
                this.connection.sendAndWait(this.cdpSession, this.getDomains().target().detachFromTarget(Optional.of(id), Optional.empty()), this.timeout);
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Exception while detaching from target", e);
            }
        }
    }

    public <X> X send(Command<X> command) {
        return this.send(command, this.timeout);
    }

    public <X> X send(Command<X> command, Duration timeout) {
        Require.nonNull("Command to send", command);
        return this.connection.sendAndWait(this.cdpSession, command, timeout);
    }

    public <X> void addListener(Event<X> event, Consumer<X> handler) {
        Require.nonNull("Event to listen for", event);
        Require.nonNull("Handler to call", handler);
        this.connection.addListener(event, (Long sequence, X x) -> handler.accept(x));
    }

    public <X> void addListener(Event<X> event, BiConsumer<Long, X> handler) {
        Require.nonNull("Event to listen for", event);
        Require.nonNull("Handler to call", handler);
        this.connection.addListener(event, handler);
    }

    public void clearListeners() {
        this.getDomains().disableAll();
        this.connection.clearListeners();
    }

    public void createSessionIfThereIsNotOne() {
        this.createSessionIfThereIsNotOne(this.windowHandle);
    }

    public void createSessionIfThereIsNotOne(@Nullable String windowHandle) {
        if (this.cdpSession == null) {
            this.createSession(windowHandle);
        } else if (!Objects.equals(this.windowHandle, windowHandle)) {
            this.disconnectSession();
            this.attachToWindow(windowHandle);
        }
    }

    public void createSession() {
        this.createSession(this.windowHandle);
    }

    public void createSession(@Nullable String windowHandle) {
        if (this.connection.isClosed()) {
            this.connection.reopen();
        }
        this.attachToWindow(windowHandle);
    }

    private void attachToWindow(String windowHandle) {
        TargetID targetId = this.findTarget(windowHandle);
        this.attachToTarget(targetId);
        this.windowHandle = windowHandle;
    }

    private void attachToTarget(TargetID targetId) {
        this.cdpSession = this.connection.sendAndWait(null, this.getDomains().target().attachToTarget(targetId), this.timeout);
        try {
            CompletableFuture.allOf(new CompletableFuture[]{this.connection.send(this.cdpSession, this.getDomains().target().setAutoAttach()), this.connection.send(this.cdpSession, this.getDomains().log().clear()).exceptionally(t2 -> {
                LOG.log(Level.SEVERE, t2.getMessage(), (Throwable)t2);
                return null;
            })}).get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Thread has been interrupted", e);
        }
        catch (ExecutionException e) {
            throw new DevToolsException(this.unwrapCause(e));
        }
        catch (java.util.concurrent.TimeoutException e) {
            throw new TimeoutException(e);
        }
    }

    private @NonNull TargetID findTarget(String windowHandle) {
        List<TargetInfo> infos = this.connection.sendAndWait(this.cdpSession, this.getDomains().target().getTargets(), this.timeout);
        return infos.stream().filter(info -> "page".equals(info.getType())).map(TargetInfo::getTargetId).filter(id -> windowHandle == null || windowHandle.endsWith(id.toString())).findAny().orElseThrow(() -> new DevToolsException("Unable to find target id of a page"));
    }

    private Throwable unwrapCause(ExecutionException e) {
        return e.getCause() != null ? e.getCause() : e;
    }

    public SessionID getCdpSession() {
        return this.cdpSession;
    }
}

