/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.selenium.Beta;
import org.openqa.selenium.docker.Device;
import org.openqa.selenium.docker.DockerException;
import org.openqa.selenium.docker.Image;
import org.openqa.selenium.docker.Port;
import org.openqa.selenium.internal.Multimap;
import org.openqa.selenium.internal.Require;

@Beta
public class ContainerConfig {
    private static final String DEFAULT_DOCKER_NETWORK = "bridge";
    private static final long DEFAULT_SHM_SIZE = 0x4000000L;
    private final Image image;
    private final Multimap<String, Map<String, Object>> portBindings;
    private final Map<String, String> envVars;
    private final Map<String, String> volumeBinds;
    private final List<Device> devices;
    private final String networkName;
    private final boolean autoRemove;
    private final long shmSize;
    private final Map<String, Object> hostConfig;
    private final Map<String, String> labels;
    private final String name;

    public ContainerConfig(Image image, Multimap<String, Map<String, Object>> portBindings, Map<String, String> envVars, Map<String, String> volumeBinds, List<Device> devices, String networkName, long shmSize) {
        this(image, portBindings, envVars, volumeBinds, devices, networkName, shmSize, Map.of(), Map.of());
    }

    public ContainerConfig(Image image, Multimap<String, Map<String, Object>> portBindings, Map<String, String> envVars, Map<String, String> volumeBinds, List<Device> devices, String networkName, long shmSize, Map<String, Object> hostConfig) {
        this(image, portBindings, envVars, volumeBinds, devices, networkName, shmSize, hostConfig, Map.of());
    }

    public ContainerConfig(Image image, Multimap<String, Map<String, Object>> portBindings, Map<String, String> envVars, Map<String, String> volumeBinds, List<Device> devices, String networkName, long shmSize, Map<String, Object> hostConfig, Map<String, String> labels) {
        this(image, portBindings, envVars, volumeBinds, devices, networkName, shmSize, hostConfig, labels, null);
    }

    public ContainerConfig(Image image, Multimap<String, Map<String, Object>> portBindings, Map<String, String> envVars, Map<String, String> volumeBinds, List<Device> devices, String networkName, long shmSize, Map<String, Object> hostConfig, Map<String, String> labels, String name) {
        this.image = image;
        this.portBindings = portBindings;
        this.envVars = envVars;
        this.volumeBinds = volumeBinds;
        this.devices = devices;
        this.networkName = networkName;
        this.autoRemove = true;
        this.shmSize = shmSize;
        this.hostConfig = hostConfig;
        this.labels = labels;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Image getImage() {
        return this.image;
    }

    public static ContainerConfig image(Image image) {
        return new ContainerConfig(image, new Multimap<String, Map<String, Object>>(), Map.of(), Map.of(), Collections.emptyList(), DEFAULT_DOCKER_NETWORK, 0x4000000L);
    }

    public ContainerConfig map(Port containerPort, Port hostPort) {
        Require.nonNull("Container port", containerPort);
        Require.nonNull("Host port", hostPort);
        if (!hostPort.getProtocol().equals(containerPort.getProtocol())) {
            throw new DockerException(String.format("Port protocols must match: %s -> %s", hostPort, containerPort));
        }
        Multimap<String, Map<String, Object>> updatedBindings = new Multimap<String, Map<String, Object>>(this.portBindings);
        updatedBindings.put(containerPort.getPort() + "/" + containerPort.getProtocol(), Map.of("HostPort", String.valueOf(hostPort.getPort()), "HostIp", ""));
        return new ContainerConfig(this.image, updatedBindings, this.envVars, this.volumeBinds, this.devices, this.networkName, this.shmSize, this.hostConfig, this.labels, this.name);
    }

    public ContainerConfig env(Map<String, String> envVars) {
        Require.nonNull("Container env vars", envVars);
        return new ContainerConfig(this.image, this.portBindings, envVars, this.volumeBinds, this.devices, this.networkName, this.shmSize, this.hostConfig, this.labels, this.name);
    }

    public ContainerConfig bind(Map<String, String> volumeBinds) {
        Require.nonNull("Container volume binds", volumeBinds);
        return new ContainerConfig(this.image, this.portBindings, this.envVars, volumeBinds, this.devices, this.networkName, this.shmSize, this.hostConfig, this.labels, this.name);
    }

    public ContainerConfig network(String networkName) {
        Require.nonNull("Container network name", networkName);
        return new ContainerConfig(this.image, this.portBindings, this.envVars, this.volumeBinds, this.devices, networkName, this.shmSize, this.hostConfig, this.labels, this.name);
    }

    public ContainerConfig shmMemorySize(long shmSize) {
        return new ContainerConfig(this.image, this.portBindings, this.envVars, this.volumeBinds, this.devices, this.networkName, shmSize, this.hostConfig, this.labels, this.name);
    }

    public ContainerConfig devices(List<Device> devices) {
        Require.nonNull("Container device files", devices);
        return new ContainerConfig(this.image, this.portBindings, this.envVars, this.volumeBinds, devices, this.networkName, this.shmSize, this.hostConfig, this.labels, this.name);
    }

    public ContainerConfig applyHostConfig(Map<String, Object> hostConfig, List<String> configKeys) {
        Map<String, Object> setHostConfig = configKeys.stream().filter(hostConfig::containsKey).filter(key -> hostConfig.get(key) != null).collect(Collectors.toMap(key -> key, hostConfig::get));
        return new ContainerConfig(this.image, this.portBindings, this.envVars, this.volumeBinds, this.devices, this.networkName, this.shmSize, setHostConfig, this.labels, this.name);
    }

    public ContainerConfig labels(Map<String, String> labels) {
        Require.nonNull("Container labels", labels);
        return new ContainerConfig(this.image, this.portBindings, this.envVars, this.volumeBinds, this.devices, this.networkName, this.shmSize, this.hostConfig, labels, this.name);
    }

    public ContainerConfig name(String name) {
        return new ContainerConfig(this.image, this.portBindings, this.envVars, this.volumeBinds, this.devices, this.networkName, this.shmSize, this.hostConfig, this.labels, name);
    }

    public String toString() {
        return "ContainerConfig{image=" + String.valueOf(this.image) + ", portBindings=" + String.valueOf(this.portBindings) + ", envVars=" + String.valueOf(this.envVars) + ", volumeBinds=" + String.valueOf(this.volumeBinds) + ", networkName=" + this.networkName + ", devices=" + String.valueOf(this.devices) + ", autoRemove=" + this.autoRemove + ", shmSize=" + this.shmSize + ", hostConfig=" + String.valueOf(this.hostConfig) + "}";
    }

    private Map<String, Object> toJson() {
        List envVars = this.envVars.keySet().stream().map(key -> String.format("%s=%s", key, this.envVars.get(key))).collect(Collectors.toList());
        List volumeBinds = this.volumeBinds.keySet().stream().map(key -> String.format("%s:%s", key, this.volumeBinds.get(key))).collect(Collectors.toList());
        List devicesMapping = this.devices.stream().map(device -> Map.of("PathOnHost", device.getPathOnHost(), "PathInContainer", device.getPathInContainer(), "CgroupPermissions", device.getCgroupPermissions())).collect(Collectors.toList());
        Map hostConfig = Map.of("PortBindings", this.portBindings.asMap(), "AutoRemove", this.autoRemove, "NetworkMode", this.networkName, "ShmSize", this.shmSize, "Binds", volumeBinds, "Devices", devicesMapping);
        if (!this.hostConfig.isEmpty()) {
            HashMap copyMap = new HashMap(hostConfig);
            copyMap.putAll(this.hostConfig);
            hostConfig = Map.copyOf(copyMap);
        }
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("Image", this.image.getId());
        config.put("Env", envVars);
        config.put("HostConfig", hostConfig);
        if (!this.labels.isEmpty()) {
            config.put("Labels", this.labels);
        }
        return Map.copyOf(config);
    }
}

