/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openqa.selenium.docker.Container;
import org.openqa.selenium.docker.ContainerConfig;
import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.docker.DockerException;
import org.openqa.selenium.docker.DockerProtocol;
import org.openqa.selenium.docker.client.ApiVersionAdapter;
import org.openqa.selenium.docker.client.DockerMessages;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class CreateContainer {
    private static final Json JSON = new Json();
    private static final Logger LOG = Logger.getLogger(CreateContainer.class.getName());
    private final DockerProtocol protocol;
    private final HttpHandler client;
    private final String apiVersion;
    private final ApiVersionAdapter adapter;

    public CreateContainer(DockerProtocol protocol, HttpHandler client, String apiVersion, ApiVersionAdapter adapter) {
        this.protocol = Require.nonNull("Protocol", protocol);
        this.client = Require.nonNull("HTTP client", client);
        this.apiVersion = Require.nonNull("API version", apiVersion);
        this.adapter = Require.nonNull("API version adapter", adapter);
    }

    public Container apply(ContainerConfig info) {
        this.protocol.getImage(info.getImage().getName());
        Map requestJson = (Map)JSON.toType(JSON.toJson(info), Json.MAP_TYPE);
        Map<String, Object> adaptedRequest = this.adapter.adaptContainerCreateRequest(requestJson);
        Object url = String.format("/v%s/containers/create", this.apiVersion);
        if (info.getName() != null && !info.getName().trim().isEmpty()) {
            String containerName = info.getName().trim();
            try {
                String encodedName = URLEncoder.encode(containerName, StandardCharsets.UTF_8.toString());
                url = (String)url + "?name=" + encodedName;
            }
            catch (UnsupportedEncodingException e) {
                throw new DockerException("Failed to encode container name: " + containerName, e);
            }
        }
        HttpResponse res = DockerMessages.throwIfNecessary(this.client.execute((HttpRequest)((HttpRequest)new HttpRequest(HttpMethod.POST, (String)url).addHeader("Content-Type", "application/json; charset=utf-8")).setContent(Contents.asJson(adaptedRequest))), "Unable to create container: ", info);
        try {
            Collection warnings;
            Map rawContainer = (Map)JSON.toType(Contents.string(res), Json.MAP_TYPE);
            if (!(rawContainer.get("Id") instanceof String)) {
                throw new DockerException("Unable to read container id: " + String.valueOf(rawContainer));
            }
            ContainerId id = new ContainerId((String)rawContainer.get("Id"));
            if (rawContainer.get("Warnings") instanceof Collection && !(warnings = (Collection)rawContainer.get("Warnings")).isEmpty()) {
                String allWarnings = warnings.stream().map(String::valueOf).collect(Collectors.joining("\n", " * ", ""));
                LOG.warning(String.format("Warnings while creating %s from %s: %s", id, info, allWarnings));
            }
            return new Container(this.protocol, id);
        }
        catch (NullPointerException | JsonException e) {
            throw new DockerException("Unable to create container from " + String.valueOf(info));
        }
    }
}

