/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.client;

import java.time.Duration;
import java.util.Set;
import java.util.logging.Logger;
import org.openqa.selenium.docker.Container;
import org.openqa.selenium.docker.ContainerConfig;
import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.docker.ContainerInfo;
import org.openqa.selenium.docker.ContainerLogs;
import org.openqa.selenium.docker.DockerException;
import org.openqa.selenium.docker.DockerProtocol;
import org.openqa.selenium.docker.Image;
import org.openqa.selenium.docker.client.AdapterFactory;
import org.openqa.selenium.docker.client.ApiVersionAdapter;
import org.openqa.selenium.docker.client.CreateContainer;
import org.openqa.selenium.docker.client.GetContainerLogs;
import org.openqa.selenium.docker.client.InspectContainer;
import org.openqa.selenium.docker.client.IsContainerPresent;
import org.openqa.selenium.docker.client.ListImages;
import org.openqa.selenium.docker.client.PullImage;
import org.openqa.selenium.docker.client.StartContainer;
import org.openqa.selenium.docker.client.StopContainer;
import org.openqa.selenium.docker.internal.Reference;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpHandler;

public class DockerClient
implements DockerProtocol {
    private static final Logger LOG = Logger.getLogger(DockerClient.class.getName());
    private final String apiVersion;
    private final ApiVersionAdapter adapter;
    private final ListImages listImages;
    private final PullImage pullImage;
    private final CreateContainer createContainer;
    private final StartContainer startContainer;
    private final StopContainer stopContainer;
    private final IsContainerPresent isContainerPresent;
    private final InspectContainer inspectContainer;
    private final GetContainerLogs containerLogs;

    public DockerClient(HttpHandler client, String apiVersion) {
        Require.nonNull("HTTP client", client);
        this.apiVersion = Require.nonNull("API version", apiVersion);
        this.adapter = AdapterFactory.createAdapter(apiVersion);
        LOG.info("Initialized DockerClient with API version " + apiVersion + " (adapter: " + this.adapter.getClass().getSimpleName() + ")");
        this.listImages = new ListImages(client, apiVersion, this.adapter);
        this.pullImage = new PullImage(client, apiVersion);
        this.createContainer = new CreateContainer(this, client, apiVersion, this.adapter);
        this.startContainer = new StartContainer(client, apiVersion);
        this.stopContainer = new StopContainer(client, apiVersion);
        this.isContainerPresent = new IsContainerPresent(client, apiVersion);
        this.inspectContainer = new InspectContainer(client, apiVersion, this.adapter);
        this.containerLogs = new GetContainerLogs(client, apiVersion);
    }

    public ApiVersionAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public String version() {
        return this.apiVersion;
    }

    @Override
    public Image getImage(String imageName) throws DockerException {
        Require.nonNull("Image name", imageName);
        Reference ref = Reference.parse(imageName);
        LOG.info("Listing local images: " + String.valueOf(ref));
        Set<Image> allImages = this.listImages.apply(ref);
        if (!allImages.isEmpty()) {
            return allImages.iterator().next();
        }
        LOG.info("Pulling " + String.valueOf(ref));
        this.pullImage.apply(ref);
        LOG.info("Pull completed. Listing local images again: " + String.valueOf(ref));
        allImages = this.listImages.apply(ref);
        if (!allImages.isEmpty()) {
            return allImages.iterator().next();
        }
        throw new DockerException("Pull appears to have succeeded, but image not present locally: " + imageName);
    }

    @Override
    public Container create(ContainerConfig config) {
        Require.nonNull("Container config", config);
        LOG.fine("Creating container: " + String.valueOf(config));
        return this.createContainer.apply(config);
    }

    @Override
    public boolean isContainerPresent(ContainerId id) throws DockerException {
        Require.nonNull("Container id", id);
        LOG.info("Checking if container is present: " + String.valueOf(id));
        return this.isContainerPresent.apply(id);
    }

    @Override
    public void startContainer(ContainerId id) throws DockerException {
        Require.nonNull("Container id", id);
        LOG.fine("Starting container: " + String.valueOf(id));
        this.startContainer.apply(id);
    }

    @Override
    public void stopContainer(ContainerId id, Duration timeout) throws DockerException {
        Require.nonNull("Container id", id);
        Require.nonNull("Timeout", timeout);
        LOG.fine("Stopping container: " + String.valueOf(id));
        this.stopContainer.apply(id, timeout);
    }

    @Override
    public ContainerInfo inspectContainer(ContainerId id) throws DockerException {
        Require.nonNull("Container id", id);
        LOG.fine("Inspecting container: " + String.valueOf(id));
        return this.inspectContainer.apply(id);
    }

    @Override
    public ContainerLogs getContainerLogs(ContainerId id) throws DockerException {
        Require.nonNull("Container id", id);
        LOG.info("Getting container logs: " + String.valueOf(id));
        return this.containerLogs.apply(id);
    }
}

