/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.client;

import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class IsContainerPresent {
    private final HttpHandler client;
    private final String apiVersion;

    public IsContainerPresent(HttpHandler client, String apiVersion) {
        this.client = Require.nonNull("Http client", client);
        this.apiVersion = Require.nonNull("API version", apiVersion);
    }

    public boolean apply(ContainerId id) {
        Require.nonNull("Container id", id);
        HttpResponse res = this.client.execute((HttpRequest)new HttpRequest(HttpMethod.GET, String.format("/v%s/containers/%s/json", this.apiVersion, id)).addHeader("Content-Type", "text/plain"));
        return res.isSuccessful();
    }
}

