/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.client;

import java.time.Duration;
import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.docker.client.DockerMessages;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;

class StopContainer {
    private final HttpHandler client;
    private final String apiVersion;

    public StopContainer(HttpHandler client, String apiVersion) {
        this.client = Require.nonNull("HTTP client", client);
        this.apiVersion = Require.nonNull("API version", apiVersion);
    }

    public void apply(ContainerId id, Duration timeout) {
        Require.nonNull("Container id", id);
        Require.nonNull("Timeout", timeout);
        String seconds = String.valueOf(timeout.toMillis() / 1000L);
        String requestUrl = String.format("/v%s/containers/%s/stop", this.apiVersion, id);
        HttpRequest request = ((HttpRequest)new HttpRequest(HttpMethod.POST, requestUrl).addHeader("Content-Type", "text/plain")).addQueryParameter("t", seconds);
        DockerMessages.throwIfNecessary(this.client.execute(request), "Unable to stop container: %s", id);
    }
}

