/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.internal.Sets;

public class CompoundConfig
implements Config {
    private final List<Config> allConfigs;

    public CompoundConfig(Config ... allConfigsInDescendingOrderOfImportance) {
        if (allConfigsInDescendingOrderOfImportance.length == 0) {
            throw new ConfigException("List of config files must be greater than 0.", new Object[0]);
        }
        this.allConfigs = List.of(allConfigsInDescendingOrderOfImportance);
    }

    @Override
    public Optional<List<String>> getAll(String section, String option) {
        Require.nonNull("Section name", section);
        Require.nonNull("Option name", option);
        List values = this.allConfigs.stream().map(config -> config.getAll(section, option)).filter(Optional::isPresent).map(Optional::get).flatMap(Collection::stream).collect(Collectors.toUnmodifiableList());
        return values.isEmpty() ? Optional.empty() : Optional.of(values);
    }

    @Override
    public Set<String> getSectionNames() {
        return this.allConfigs.stream().map(Config::getSectionNames).flatMap(Collection::stream).collect(Sets.toSortedSet());
    }

    @Override
    public Set<String> getOptions(String section) {
        Require.nonNull("Section name to get options for", section);
        return this.allConfigs.stream().map(config -> config.getOptions(section)).flatMap(Collection::stream).collect(Sets.toSortedSet());
    }
}

