/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import java.util.AbstractMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.internal.Sets;

public class ConcatenatingConfig
implements Config {
    private final String prefix;
    private final char separator;
    private final Map<String, String> values;

    public ConcatenatingConfig(String prefix, char separator, Map<?, ?> values) {
        this.prefix = prefix == null || prefix.isEmpty() ? "" : prefix + separator;
        this.separator = separator;
        this.values = Require.nonNull("Config values", values).entrySet().stream().peek(entry -> Require.nonNull("Key", entry.getKey())).peek(entry -> Require.nonNull("Value", entry.getValue())).map(entry -> new AbstractMap.SimpleImmutableEntry<String, String>(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()))).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Optional<List<String>> getAll(String section, String option) {
        Require.nonNull("Section name", section);
        Require.nonNull("Option name", option);
        String key = this.prefix + section + this.separator + option;
        return this.values.entrySet().stream().filter(entry -> key.equalsIgnoreCase((String)entry.getKey())).map(Map.Entry::getValue).findFirst().map(List::of);
    }

    @Override
    public Set<String> getSectionNames() {
        String actualPrefix = this.prefix.toLowerCase(Locale.ENGLISH);
        return this.values.keySet().stream().filter(key -> key.toLowerCase(Locale.ENGLISH).startsWith(actualPrefix)).filter(key -> key.length() > actualPrefix.length() + 1).map(key -> key.substring(actualPrefix.length())).filter(key -> key.indexOf(this.separator) > -1).map(key -> key.substring(0, key.indexOf(this.separator))).map(key -> key.toLowerCase(Locale.ENGLISH)).collect(Sets.toSortedSet());
    }

    @Override
    public Set<String> getOptions(String section) {
        Require.nonNull("Section name to get options for", section);
        String actualPrefix = String.format("%s%s_", this.prefix, section).toLowerCase(Locale.ENGLISH);
        return this.values.keySet().stream().filter(key -> key.toLowerCase(Locale.ENGLISH).startsWith(actualPrefix)).filter(key -> key.length() > actualPrefix.length() + 1).map(key -> key.substring(actualPrefix.length())).map(key -> key.toLowerCase(Locale.ENGLISH)).collect(Sets.toSortedSet());
    }
}

