/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import java.lang.reflect.Type;
import java.util.function.Consumer;
import org.openqa.selenium.events.Event;
import org.openqa.selenium.events.EventListener;
import org.openqa.selenium.events.EventName;
import org.openqa.selenium.grid.data.SessionClosedData;
import org.openqa.selenium.grid.data.SessionClosedReason;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.SessionId;

public class SessionClosedEvent
extends Event {
    private static final EventName SESSION_CLOSED = new EventName("session-closed");

    public SessionClosedEvent(SessionId id) {
        this(id, SessionClosedReason.QUIT_COMMAND);
    }

    public SessionClosedEvent(SessionId id, SessionClosedReason reason) {
        super(SESSION_CLOSED, new SessionClosedData(id, reason));
        Require.nonNull("Session ID", id);
        Require.nonNull("Reason", reason);
    }

    public static EventListener<SessionClosedData> listener(Consumer<SessionClosedData> handler) {
        Require.nonNull("Handler", handler);
        return new EventListener<SessionClosedData>(SESSION_CLOSED, (Type)((Object)SessionClosedData.class), handler);
    }

    public static EventListener<SessionClosedData> sessionListener(Consumer<SessionId> handler) {
        Require.nonNull("Handler", handler);
        return new EventListener<SessionClosedData>(SESSION_CLOSED, (Type)((Object)SessionClosedData.class), data -> handler.accept(data.getSessionId()));
    }
}

