/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import java.net.URI;
import java.time.Duration;
import java.time.Instant;

public class SessionRemovalInfo {
    private final Instant removedAt = Instant.now();
    private final String reason;
    private final URI nodeUri;

    public SessionRemovalInfo(String reason, URI nodeUri) {
        this.reason = reason;
        this.nodeUri = nodeUri;
    }

    public String toString() {
        Duration elapsed = Duration.between(this.removedAt, Instant.now());
        long seconds = Math.max(elapsed.toSeconds(), 0L);
        Object timeAgo = seconds == 1L ? "1 second ago" : seconds + " seconds ago";
        return String.format("removed at %s (%s), reason: %s, node: %s", this.removedAt, timeAgo, this.reason, this.nodeUri != null ? this.nodeUri : "unknown");
    }
}

