/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;

public class CheckOriginHeader
implements Filter {
    private final Set<String> allowedHosts;
    private final Set<String> skipChecksOn;

    public CheckOriginHeader(Collection<String> allowedOriginHosts, Set<String> skipChecksOn) {
        Require.nonNull("Allowed origins list", allowedOriginHosts);
        this.allowedHosts = Set.copyOf(allowedOriginHosts);
        this.skipChecksOn = Set.copyOf((Collection)Require.nonNull("URLs where checks are skipped", skipChecksOn));
    }

    @Override
    public HttpHandler apply(HttpHandler httpHandler) {
        Require.nonNull("Next handler", httpHandler);
        return req -> {
            if (this.skipChecksOn.contains(req.getUri())) {
                return httpHandler.execute(req);
            }
            String origin = req.getHeader("Origin");
            if (origin != null && !this.allowedHosts.contains(origin)) {
                return (HttpResponse)((HttpResponse)new HttpResponse().setStatus(500).addHeader("Content-Type", "application/json; charset=utf-8")).setContent(Contents.asJson(Map.of("value", Map.of("error", "unknown error", "message", "Origin not allowed: " + origin, "stacktrace", ""))));
            }
            return httpHandler.execute(req);
        };
    }
}

