/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.openqa.selenium.grid.web.Resource;
import org.openqa.selenium.internal.Require;

public class MergedResource
implements Resource {
    private final Resource base;
    private final Optional<Resource> next;

    public MergedResource(Resource base) {
        this(base, null);
    }

    private MergedResource(Resource base, Resource next) {
        this.base = Require.nonNull("Base resource", base);
        this.next = Optional.ofNullable(next);
    }

    public MergedResource alsoCheck(Resource resource) {
        return new MergedResource(this, Require.nonNull("Resource", resource));
    }

    @Override
    public String name() {
        return this.base.name();
    }

    @Override
    public Optional<Resource> get(String path) {
        Optional<Resource> resource = this.base.get(path);
        if (resource.isPresent()) {
            return resource;
        }
        if (this.next.isEmpty()) {
            return Optional.empty();
        }
        return this.next.get().get(path);
    }

    @Override
    public boolean isDirectory() {
        return this.base.isDirectory() || this.next.map(Resource::isDirectory).orElse(false) != false;
    }

    @Override
    public Set<Resource> list() {
        HashSet<Resource> resources = new HashSet<Resource>(this.base.list());
        this.next.ifPresent(res -> resources.addAll(res.list()));
        return Set.copyOf(resources);
    }

    @Override
    public Optional<byte[]> read() {
        Optional<byte[]> data = this.base.read();
        if (data.isPresent()) {
            return data;
        }
        if (this.next.isEmpty()) {
            return Optional.empty();
        }
        return this.next.get().read();
    }
}

