/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import com.google.auto.service.AutoService;
import java.util.Optional;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.WebDriverInfo;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.service.DriverFinder;

@AutoService(value={WebDriverInfo.class})
public class InternetExplorerDriverInfo
implements WebDriverInfo {
    private static final Logger LOG = Logger.getLogger(InternetExplorerDriverInfo.class.getName());

    @Override
    public String getDisplayName() {
        return "Internet Explorer";
    }

    @Override
    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities("browserName", Browser.IE.browserName());
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        return Browser.IE.is(capabilities) || capabilities.getCapability("se:ieOptions") != null;
    }

    @Override
    public boolean isSupportingCdp() {
        return false;
    }

    @Override
    public boolean isSupportingBiDi() {
        return false;
    }

    @Override
    public boolean isAvailable() {
        return Platform.getCurrent().is(Platform.WINDOWS) && new DriverFinder(InternetExplorerDriverService.createDefaultService(), this.getCanonicalCapabilities()).isAvailable();
    }

    @Override
    public boolean isPresent() {
        return Platform.getCurrent().is(Platform.WINDOWS) && new DriverFinder(InternetExplorerDriverService.createDefaultService(), this.getCanonicalCapabilities()).isPresent();
    }

    @Override
    public int getMaximumSimultaneousSessions() {
        return 1;
    }

    @Override
    public Optional<WebDriver> createDriver(Capabilities capabilities, ClientConfig clientConfig) throws SessionNotCreatedException {
        if (!this.isAvailable()) {
            return Optional.empty();
        }
        return Optional.of(new InternetExplorerDriver(new InternetExplorerOptions().merge(capabilities), clientConfig));
    }
}

