/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.netty.server;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.stream.ChunkedStream;
import java.io.InputStream;
import org.openqa.selenium.remote.http.HttpResponse;

public class ResponseConverter
extends ChannelOutboundHandlerAdapter {
    private static final int CHUNK_SIZE = 0x100000;
    private static final ThreadLocal<byte[]> CHUNK_CACHE = ThreadLocal.withInitial(() -> new byte[0x100000]);
    private final boolean allowCors;

    public ResponseConverter(boolean allowCors) {
        this.allowCors = allowCors;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof HttpResponse)) {
            super.write(ctx, msg, promise);
            return;
        }
        HttpResponse seResponse = (HttpResponse)msg;
        byte[] buffer = CHUNK_CACHE.get();
        InputStream is = (InputStream)seResponse.getContent().get();
        int byteCount = is.readNBytes(buffer, 0, buffer.length);
        if (byteCount < 0x100000) {
            is.close();
            DefaultFullHttpResponse first = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(seResponse.getStatus()), Unpooled.copiedBuffer(buffer, 0, byteCount));
            first.headers().addInt(HttpHeaderNames.CONTENT_LENGTH, byteCount);
            this.copyHeaders(seResponse, first);
            ctx.write(first);
        } else {
            DefaultHttpResponse first = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(seResponse.getStatus()));
            first.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            this.copyHeaders(seResponse, first);
            ctx.write(first);
            ctx.write(new DefaultHttpContent(Unpooled.copiedBuffer(buffer)));
            HttpChunkedInput writer = new HttpChunkedInput(new ChunkedStream(is, 0x100000));
            ChannelFuture future = ctx.write(writer);
            future.addListener(ignored -> {
                is.close();
                ctx.flush();
            });
        }
    }

    private void copyHeaders(HttpResponse seResponse, DefaultHttpResponse first) {
        seResponse.forEachHeader((name, value) -> {
            if (HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase((CharSequence)name) || HttpHeaderNames.TRANSFER_ENCODING.contentEqualsIgnoreCase((CharSequence)name)) {
                return;
            }
            if (value == null) {
                return;
            }
            first.headers().add((String)name, value);
        });
        if (this.allowCors) {
            first.headers().add("Access-Control-Allow-Origin", (Object)"*");
            first.headers().add("Access-Control-Allow-Methods", (Object)"GET,POST,DELETE");
            first.headers().add("Access-Control-Allow-Headers", (Object)"Accept,Content-Type");
        }
    }
}

