/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;

class InputStreamContentSupplier
implements Contents.Supplier {
    private final InputStream stream;
    private final long length;

    InputStreamContentSupplier(InputStream stream, long length) {
        this.stream = Require.nonNull("InputStream", stream);
        this.length = length;
    }

    @Override
    public InputStream get() {
        return this.stream;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void close() {
        try {
            this.stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return String.format("Contents.fromStream(%s bytes)", this.length);
    }

    @Override
    public String contentAsString(Charset charset) {
        throw new UnsupportedOperationException("Don't serialize binary stream - it might be large");
    }

    @Override
    public Reader reader(Charset charset) {
        throw new UnsupportedOperationException("Don't read binary stream  - it might be large");
    }
}

