/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.auto.service.AutoService;
import java.util.Optional;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.WebDriverInfo;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.service.DriverFinder;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariOptions;
import org.openqa.selenium.safari.SafariTechPreviewDriverService;

@AutoService(value={WebDriverInfo.class})
public class SafariTechPreviewDriverInfo
implements WebDriverInfo {
    private static final Logger LOG = Logger.getLogger(SafariTechPreviewDriverInfo.class.getName());

    @Override
    public String getDisplayName() {
        return "Safari Technology Preview";
    }

    @Override
    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities("browserName", Browser.SAFARI_TECH_PREVIEW.browserName());
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        if (Browser.SAFARI_TECH_PREVIEW.browserName().equalsIgnoreCase(capabilities.getBrowserName())) {
            return true;
        }
        return capabilities.asMap().keySet().stream().anyMatch(key -> key.startsWith("safari:"));
    }

    @Override
    public boolean isSupportingCdp() {
        return false;
    }

    @Override
    public boolean isSupportingBiDi() {
        return false;
    }

    @Override
    public boolean isAvailable() {
        return Platform.getCurrent().is(Platform.MAC) && new DriverFinder(SafariTechPreviewDriverService.createDefaultService(), this.getCanonicalCapabilities()).isAvailable();
    }

    @Override
    public boolean isPresent() {
        return Platform.getCurrent().is(Platform.MAC) && new DriverFinder(SafariTechPreviewDriverService.createDefaultService(), this.getCanonicalCapabilities()).isPresent();
    }

    @Override
    public int getMaximumSimultaneousSessions() {
        return 1;
    }

    @Override
    public Optional<WebDriver> createDriver(Capabilities capabilities, ClientConfig clientConfig) throws SessionNotCreatedException {
        if (!this.isAvailable()) {
            return Optional.empty();
        }
        return Optional.of(new SafariDriver(new SafariOptions(capabilities), clientConfig));
    }
}

