/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.ui;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.support.ui.Sleeper;
import org.openqa.selenium.support.ui.Wait;

public class FluentWait<T>
implements Wait<T> {
    protected static final long DEFAULT_SLEEP_TIMEOUT = 500L;
    private static final Duration DEFAULT_WAIT_DURATION = Duration.ofMillis(500L);
    protected final T input;
    protected final Clock clock;
    protected final Sleeper sleeper;
    protected Duration timeout = DEFAULT_WAIT_DURATION;
    protected Duration interval = DEFAULT_WAIT_DURATION;
    protected Supplier<String> messageSupplier = () -> null;
    protected final List<Class<? extends Throwable>> ignoredExceptions = new ArrayList<Class<? extends Throwable>>();

    public FluentWait(T input) {
        this(input, Clock.systemDefaultZone(), Sleeper.SYSTEM_SLEEPER);
    }

    public FluentWait(T input, Clock clock, Sleeper sleeper) {
        this.input = input;
        this.clock = Require.nonNull("Clock", clock);
        this.sleeper = Require.nonNull("Sleeper", sleeper);
    }

    public FluentWait<T> withTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public FluentWait<T> withMessage(String message) {
        this.messageSupplier = () -> message;
        return this;
    }

    public FluentWait<T> withMessage(Supplier<String> messageSupplier) {
        this.messageSupplier = messageSupplier;
        return this;
    }

    public FluentWait<T> pollingEvery(Duration interval) {
        this.interval = interval;
        return this;
    }

    public <K extends Throwable> FluentWait<T> ignoreAll(Collection<Class<? extends K>> types) {
        this.ignoredExceptions.addAll(types);
        return this;
    }

    public FluentWait<T> ignoring(Class<? extends Throwable> exceptionType) {
        return this.ignoreAll(List.of(exceptionType));
    }

    public FluentWait<T> ignoring(Class<? extends Throwable> firstType, Class<? extends Throwable> secondType) {
        return this.ignoreAll(List.of(firstType, secondType));
    }

    @Override
    public <V> V until(Function<? super T, V> isTrue) {
        Instant end = this.clock.instant().plus(this.timeout);
        while (true) {
            Throwable lastException;
            try {
                V value = isTrue.apply(this.input);
                if (value != null && (Boolean.class != value.getClass() || Boolean.TRUE.equals(value))) {
                    return value;
                }
                lastException = null;
            }
            catch (Throwable e) {
                lastException = this.propagateIfNotIgnored(e);
            }
            if (end.isBefore(this.clock.instant())) {
                String message = this.messageSupplier != null ? this.messageSupplier.get() : null;
                String timeoutMessage = String.format("Expected condition failed: %s%n(tried for %s with %d milliseconds interval)", message == null ? "waiting for " + String.valueOf(isTrue) : message, FluentWait.formatTimeout(this.timeout), this.interval.toMillis());
                throw this.timeoutException(timeoutMessage, lastException);
            }
            try {
                this.sleeper.sleep(this.interval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WebDriverException(e);
            }
        }
    }

    static String formatTimeout(Duration timeout) {
        BigDecimal seconds = BigDecimal.valueOf(timeout.toMillis()).divide(BigDecimal.valueOf(1000L), 3, RoundingMode.HALF_UP);
        String value = seconds.stripTrailingZeros().toPlainString();
        boolean singular = seconds.compareTo(BigDecimal.ONE) == 0;
        return value + (singular ? " second" : " seconds");
    }

    private Throwable propagateIfNotIgnored(Throwable e) {
        for (Class<? extends Throwable> ignoredException : this.ignoredExceptions) {
            if (!ignoredException.isInstance(e)) continue;
            return e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    protected RuntimeException timeoutException(String message, Throwable lastException) {
        throw new TimeoutException(message, lastException);
    }
}

