package org.openqa.selenium.devtools.v142.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Source of service worker router.
 */
public enum ServiceWorkerRouterSource {

    NETWORK("network"), CACHE("cache"), FETCH_EVENT("fetch-event"), RACE_NETWORK_AND_FETCH_HANDLER("race-network-and-fetch-handler"), RACE_NETWORK_AND_CACHE("race-network-and-cache");

    private String value;

    ServiceWorkerRouterSource(String value) {
        this.value = value;
    }

    public static ServiceWorkerRouterSource fromString(String s) {
        return java.util.Arrays.stream(ServiceWorkerRouterSource.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within ServiceWorkerRouterSource "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static ServiceWorkerRouterSource fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
