package org.openqa.selenium.devtools.v142.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class AttributionReportingNamedBudgetDef {

    private final java.lang.String name;

    private final java.lang.Integer budget;

    public AttributionReportingNamedBudgetDef(java.lang.String name, java.lang.Integer budget) {
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.budget = java.util.Objects.requireNonNull(budget, "budget is required");
    }

    public java.lang.String getName() {
        return name;
    }

    public java.lang.Integer getBudget() {
        return budget;
    }

    private static AttributionReportingNamedBudgetDef fromJson(JsonInput input) {
        java.lang.String name = null;
        java.lang.Integer budget = 0;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "name":
                    name = input.nextString();
                    break;
                case "budget":
                    budget = input.nextNumber().intValue();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AttributionReportingNamedBudgetDef(name, budget);
    }
}
