package org.openqa.selenium.devtools.v143.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class MixedContentIssueDetails {

    private final java.util.Optional<org.openqa.selenium.devtools.v143.audits.model.MixedContentResourceType> resourceType;

    private final org.openqa.selenium.devtools.v143.audits.model.MixedContentResolutionStatus resolutionStatus;

    private final java.lang.String insecureURL;

    private final java.lang.String mainResourceURL;

    private final java.util.Optional<org.openqa.selenium.devtools.v143.audits.model.AffectedRequest> request;

    private final java.util.Optional<org.openqa.selenium.devtools.v143.audits.model.AffectedFrame> frame;

    public MixedContentIssueDetails(java.util.Optional<org.openqa.selenium.devtools.v143.audits.model.MixedContentResourceType> resourceType, org.openqa.selenium.devtools.v143.audits.model.MixedContentResolutionStatus resolutionStatus, java.lang.String insecureURL, java.lang.String mainResourceURL, java.util.Optional<org.openqa.selenium.devtools.v143.audits.model.AffectedRequest> request, java.util.Optional<org.openqa.selenium.devtools.v143.audits.model.AffectedFrame> frame) {
        this.resourceType = resourceType;
        this.resolutionStatus = java.util.Objects.requireNonNull(resolutionStatus, "resolutionStatus is required");
        this.insecureURL = java.util.Objects.requireNonNull(insecureURL, "insecureURL is required");
        this.mainResourceURL = java.util.Objects.requireNonNull(mainResourceURL, "mainResourceURL is required");
        this.request = request;
        this.frame = frame;
    }

    /**
     * The type of resource causing the mixed content issue (css, js, iframe,
     * form,...). Marked as optional because it is mapped to from
     * blink::mojom::RequestContextType, which will be replaced
     * by network::mojom::RequestDestination
     */
    public java.util.Optional<org.openqa.selenium.devtools.v143.audits.model.MixedContentResourceType> getResourceType() {
        return resourceType;
    }

    /**
     * The way the mixed content issue is being resolved.
     */
    public org.openqa.selenium.devtools.v143.audits.model.MixedContentResolutionStatus getResolutionStatus() {
        return resolutionStatus;
    }

    /**
     * The unsafe http url causing the mixed content issue.
     */
    public java.lang.String getInsecureURL() {
        return insecureURL;
    }

    /**
     * The url responsible for the call to an unsafe url.
     */
    public java.lang.String getMainResourceURL() {
        return mainResourceURL;
    }

    /**
     * The mixed content request.
     * Does not always exist (e.g. for unsafe form submission urls).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v143.audits.model.AffectedRequest> getRequest() {
        return request;
    }

    /**
     * Optional because not every mixed content issue is necessarily linked to a frame.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v143.audits.model.AffectedFrame> getFrame() {
        return frame;
    }

    private static MixedContentIssueDetails fromJson(JsonInput input) {
        java.util.Optional<org.openqa.selenium.devtools.v143.audits.model.MixedContentResourceType> resourceType = java.util.Optional.empty();
        org.openqa.selenium.devtools.v143.audits.model.MixedContentResolutionStatus resolutionStatus = null;
        java.lang.String insecureURL = null;
        java.lang.String mainResourceURL = null;
        java.util.Optional<org.openqa.selenium.devtools.v143.audits.model.AffectedRequest> request = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v143.audits.model.AffectedFrame> frame = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "resourceType":
                    resourceType = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.audits.model.MixedContentResourceType.class));
                    break;
                case "resolutionStatus":
                    resolutionStatus = input.read(org.openqa.selenium.devtools.v143.audits.model.MixedContentResolutionStatus.class);
                    break;
                case "insecureURL":
                    insecureURL = input.nextString();
                    break;
                case "mainResourceURL":
                    mainResourceURL = input.nextString();
                    break;
                case "request":
                    request = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.audits.model.AffectedRequest.class));
                    break;
                case "frame":
                    frame = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.audits.model.AffectedFrame.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new MixedContentIssueDetails(resourceType, resolutionStatus, insecureURL, mainResourceURL, request, frame);
    }
}
