package org.openqa.selenium.devtools.v143.bluetoothemulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Indicates the various types of descriptor operation.
 */
public enum DescriptorOperationType {

    READ("read"), WRITE("write");

    private String value;

    DescriptorOperationType(String value) {
        this.value = value;
    }

    public static DescriptorOperationType fromString(String s) {
        return java.util.Arrays.stream(DescriptorOperationType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within DescriptorOperationType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static DescriptorOperationType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
