package org.openqa.selenium.devtools.v143.cachestorage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Cache identifier.
 */
public class Cache {

    private final org.openqa.selenium.devtools.v143.cachestorage.model.CacheId cacheId;

    private final java.lang.String securityOrigin;

    private final java.lang.String storageKey;

    private final java.util.Optional<org.openqa.selenium.devtools.v143.storage.model.StorageBucket> storageBucket;

    private final java.lang.String cacheName;

    public Cache(org.openqa.selenium.devtools.v143.cachestorage.model.CacheId cacheId, java.lang.String securityOrigin, java.lang.String storageKey, java.util.Optional<org.openqa.selenium.devtools.v143.storage.model.StorageBucket> storageBucket, java.lang.String cacheName) {
        this.cacheId = java.util.Objects.requireNonNull(cacheId, "cacheId is required");
        this.securityOrigin = java.util.Objects.requireNonNull(securityOrigin, "securityOrigin is required");
        this.storageKey = java.util.Objects.requireNonNull(storageKey, "storageKey is required");
        this.storageBucket = storageBucket;
        this.cacheName = java.util.Objects.requireNonNull(cacheName, "cacheName is required");
    }

    /**
     * An opaque unique id of the cache.
     */
    public org.openqa.selenium.devtools.v143.cachestorage.model.CacheId getCacheId() {
        return cacheId;
    }

    /**
     * Security origin of the cache.
     */
    public java.lang.String getSecurityOrigin() {
        return securityOrigin;
    }

    /**
     * Storage key of the cache.
     */
    public java.lang.String getStorageKey() {
        return storageKey;
    }

    /**
     * Storage bucket of the cache.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v143.storage.model.StorageBucket> getStorageBucket() {
        return storageBucket;
    }

    /**
     * The name of the cache.
     */
    public java.lang.String getCacheName() {
        return cacheName;
    }

    private static Cache fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v143.cachestorage.model.CacheId cacheId = null;
        java.lang.String securityOrigin = null;
        java.lang.String storageKey = null;
        java.util.Optional<org.openqa.selenium.devtools.v143.storage.model.StorageBucket> storageBucket = java.util.Optional.empty();
        java.lang.String cacheName = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "cacheId":
                    cacheId = input.read(org.openqa.selenium.devtools.v143.cachestorage.model.CacheId.class);
                    break;
                case "securityOrigin":
                    securityOrigin = input.nextString();
                    break;
                case "storageKey":
                    storageKey = input.nextString();
                    break;
                case "storageBucket":
                    storageBucket = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.storage.model.StorageBucket.class));
                    break;
                case "cacheName":
                    cacheName = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new Cache(cacheId, securityOrigin, storageKey, storageBucket, cacheName);
    }
}
