package org.openqa.selenium.devtools.v143.css;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * This domain exposes CSS read/write operations. All CSS objects (stylesheets, rules, and styles)
 * have an associated `id` used in subsequent operations on the related object. Each object type has
 * a specific `id` structure, and those are not interchangeable between objects of different kinds.
 * CSS objects can be loaded using the `get*ForNode()` calls (which accept a DOM node id). A client
 * can also keep track of stylesheets via the `styleSheetAdded`/`styleSheetRemoved` events and
 * subsequently load the required stylesheet contents using the `getStyleSheet[Text]()` methods.
 */
@Beta()
public class CSS {

    /**
     * Inserts a new rule with the given `ruleText` in a stylesheet with given `styleSheetId`, at the
     * position specified by `location`.
     */
    public static Command<org.openqa.selenium.devtools.v143.css.model.CSSRule> addRule(org.openqa.selenium.devtools.v143.css.model.StyleSheetId styleSheetId, java.lang.String ruleText, org.openqa.selenium.devtools.v143.css.model.SourceRange location, java.util.Optional<org.openqa.selenium.devtools.v143.dom.model.NodeId> nodeForPropertySyntaxValidation) {
        java.util.Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        java.util.Objects.requireNonNull(ruleText, "ruleText is required");
        java.util.Objects.requireNonNull(location, "location is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("styleSheetId", styleSheetId);
        params.put("ruleText", ruleText);
        params.put("location", location);
        nodeForPropertySyntaxValidation.ifPresent(p -> params.put("nodeForPropertySyntaxValidation", p));
        return new Command<>("CSS.addRule", Map.copyOf(params), ConverterFunctions.map("rule", org.openqa.selenium.devtools.v143.css.model.CSSRule.class));
    }

    /**
     * Returns all class names from specified stylesheet.
     */
    public static Command<java.util.List<java.lang.String>> collectClassNames(org.openqa.selenium.devtools.v143.css.model.StyleSheetId styleSheetId) {
        java.util.Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("styleSheetId", styleSheetId);
        return new Command<>("CSS.collectClassNames", Map.copyOf(params), ConverterFunctions.map("classNames", input -> input.readArray(java.lang.String.class)));
    }

    /**
     * Creates a new special "via-inspector" stylesheet in the frame with given `frameId`.
     */
    public static Command<org.openqa.selenium.devtools.v143.css.model.StyleSheetId> createStyleSheet(org.openqa.selenium.devtools.v143.page.model.FrameId frameId, java.util.Optional<java.lang.Boolean> force) {
        java.util.Objects.requireNonNull(frameId, "frameId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("frameId", frameId);
        force.ifPresent(p -> params.put("force", p));
        return new Command<>("CSS.createStyleSheet", Map.copyOf(params), ConverterFunctions.map("styleSheetId", org.openqa.selenium.devtools.v143.css.model.StyleSheetId.class));
    }

    /**
     * Disables the CSS agent for the given page.
     */
    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("CSS.disable", Map.copyOf(params));
    }

    /**
     * Enables the CSS agent for the given page. Clients should not assume that the CSS agent has been
     * enabled until the result of this command is received.
     */
    public static Command<Void> enable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("CSS.enable", Map.copyOf(params));
    }

    /**
     * Ensures that the given node will have specified pseudo-classes whenever its style is computed by
     * the browser.
     */
    public static Command<Void> forcePseudoState(org.openqa.selenium.devtools.v143.dom.model.NodeId nodeId, java.util.List<java.lang.String> forcedPseudoClasses) {
        java.util.Objects.requireNonNull(nodeId, "nodeId is required");
        java.util.Objects.requireNonNull(forcedPseudoClasses, "forcedPseudoClasses is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("nodeId", nodeId);
        params.put("forcedPseudoClasses", forcedPseudoClasses);
        return new Command<>("CSS.forcePseudoState", Map.copyOf(params));
    }

    /**
     * Ensures that the given node is in its starting-style state.
     */
    public static Command<Void> forceStartingStyle(org.openqa.selenium.devtools.v143.dom.model.NodeId nodeId, java.lang.Boolean forced) {
        java.util.Objects.requireNonNull(nodeId, "nodeId is required");
        java.util.Objects.requireNonNull(forced, "forced is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("nodeId", nodeId);
        params.put("forced", forced);
        return new Command<>("CSS.forceStartingStyle", Map.copyOf(params));
    }

    public static class GetBackgroundColorsResponse {

        private final java.util.Optional<java.util.List<java.lang.String>> backgroundColors;

        private final java.util.Optional<java.lang.String> computedFontSize;

        private final java.util.Optional<java.lang.String> computedFontWeight;

        public GetBackgroundColorsResponse(java.util.Optional<java.util.List<java.lang.String>> backgroundColors, java.util.Optional<java.lang.String> computedFontSize, java.util.Optional<java.lang.String> computedFontWeight) {
            this.backgroundColors = backgroundColors;
            this.computedFontSize = computedFontSize;
            this.computedFontWeight = computedFontWeight;
        }

        /**
         * The range of background colors behind this element, if it contains any visible text. If no
         * visible text is present, this will be undefined. In the case of a flat background color,
         * this will consist of simply that color. In the case of a gradient, this will consist of each
         * of the color stops. For anything more complicated, this will be an empty array. Images will
         * be ignored (as if the image had failed to load).
         */
        public java.util.Optional<java.util.List<java.lang.String>> getBackgroundColors() {
            return backgroundColors;
        }

        /**
         * The computed font size for this node, as a CSS computed value string (e.g. '12px').
         */
        public java.util.Optional<java.lang.String> getComputedFontSize() {
            return computedFontSize;
        }

        /**
         * The computed font weight for this node, as a CSS computed value string (e.g. 'normal' or
         * '100').
         */
        public java.util.Optional<java.lang.String> getComputedFontWeight() {
            return computedFontWeight;
        }

        private static GetBackgroundColorsResponse fromJson(JsonInput input) {
            java.util.Optional<java.util.List<java.lang.String>> backgroundColors = java.util.Optional.empty();
            java.util.Optional<java.lang.String> computedFontSize = java.util.Optional.empty();
            java.util.Optional<java.lang.String> computedFontWeight = java.util.Optional.empty();
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "backgroundColors":
                        backgroundColors = java.util.Optional.ofNullable(input.readArray(java.lang.String.class));
                        break;
                    case "computedFontSize":
                        computedFontSize = java.util.Optional.ofNullable(input.nextString());
                        break;
                    case "computedFontWeight":
                        computedFontWeight = java.util.Optional.ofNullable(input.nextString());
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new GetBackgroundColorsResponse(backgroundColors, computedFontSize, computedFontWeight);
        }
    }

    public static Command<org.openqa.selenium.devtools.v143.css.CSS.GetBackgroundColorsResponse> getBackgroundColors(org.openqa.selenium.devtools.v143.dom.model.NodeId nodeId) {
        java.util.Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("nodeId", nodeId);
        return new Command<>("CSS.getBackgroundColors", Map.copyOf(params), input -> input.read(org.openqa.selenium.devtools.v143.css.CSS.GetBackgroundColorsResponse.class));
    }

    public static class GetComputedStyleForNodeResponse {

        private final java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSComputedStyleProperty> computedStyle;

        private final org.openqa.selenium.devtools.v143.css.model.ComputedStyleExtraFields extraFields;

        public GetComputedStyleForNodeResponse(java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSComputedStyleProperty> computedStyle, org.openqa.selenium.devtools.v143.css.model.ComputedStyleExtraFields extraFields) {
            this.computedStyle = java.util.Objects.requireNonNull(computedStyle, "computedStyle is required");
            this.extraFields = java.util.Objects.requireNonNull(extraFields, "extraFields is required");
        }

        /**
         * Computed style for the specified DOM node.
         */
        public java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSComputedStyleProperty> getComputedStyle() {
            return computedStyle;
        }

        /**
         * A list of non-standard "extra fields" which blink stores alongside each
         * computed style.
         */
        public org.openqa.selenium.devtools.v143.css.model.ComputedStyleExtraFields getExtraFields() {
            return extraFields;
        }

        private static GetComputedStyleForNodeResponse fromJson(JsonInput input) {
            java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSComputedStyleProperty> computedStyle = null;
            org.openqa.selenium.devtools.v143.css.model.ComputedStyleExtraFields extraFields = null;
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "computedStyle":
                        computedStyle = input.readArray(org.openqa.selenium.devtools.v143.css.model.CSSComputedStyleProperty.class);
                        break;
                    case "extraFields":
                        extraFields = input.read(org.openqa.selenium.devtools.v143.css.model.ComputedStyleExtraFields.class);
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new GetComputedStyleForNodeResponse(computedStyle, extraFields);
        }
    }

    /**
     * Returns the computed style for a DOM node identified by `nodeId`.
     */
    public static Command<org.openqa.selenium.devtools.v143.css.CSS.GetComputedStyleForNodeResponse> getComputedStyleForNode(org.openqa.selenium.devtools.v143.dom.model.NodeId nodeId) {
        java.util.Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("nodeId", nodeId);
        return new Command<>("CSS.getComputedStyleForNode", Map.copyOf(params), input -> input.read(org.openqa.selenium.devtools.v143.css.CSS.GetComputedStyleForNodeResponse.class));
    }

    /**
     * Resolve the specified values in the context of the provided element.
     * For example, a value of '1em' is evaluated according to the computed
     * 'font-size' of the element and a value 'calc(1px + 2px)' will be
     * resolved to '3px'.
     * If the `propertyName` was specified the `values` are resolved as if
     * they were property's declaration. If a value cannot be parsed according
     * to the provided property syntax, the value is parsed using combined
     * syntax as if null `propertyName` was provided. If the value cannot be
     * resolved even then, return the provided value without any changes.
     */
    @Beta()
    public static Command<java.util.List<java.lang.String>> resolveValues(java.util.List<java.lang.String> values, org.openqa.selenium.devtools.v143.dom.model.NodeId nodeId, java.util.Optional<java.lang.String> propertyName, java.util.Optional<org.openqa.selenium.devtools.v143.dom.model.PseudoType> pseudoType, java.util.Optional<java.lang.String> pseudoIdentifier) {
        java.util.Objects.requireNonNull(values, "values is required");
        java.util.Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("values", values);
        params.put("nodeId", nodeId);
        propertyName.ifPresent(p -> params.put("propertyName", p));
        pseudoType.ifPresent(p -> params.put("pseudoType", p));
        pseudoIdentifier.ifPresent(p -> params.put("pseudoIdentifier", p));
        return new Command<>("CSS.resolveValues", Map.copyOf(params), ConverterFunctions.map("results", input -> input.readArray(java.lang.String.class)));
    }

    @Beta()
    public static Command<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSProperty>> getLonghandProperties(java.lang.String shorthandName, java.lang.String value) {
        java.util.Objects.requireNonNull(shorthandName, "shorthandName is required");
        java.util.Objects.requireNonNull(value, "value is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("shorthandName", shorthandName);
        params.put("value", value);
        return new Command<>("CSS.getLonghandProperties", Map.copyOf(params), ConverterFunctions.map("longhandProperties", input -> input.readArray(org.openqa.selenium.devtools.v143.css.model.CSSProperty.class)));
    }

    public static class GetInlineStylesForNodeResponse {

        private final java.util.Optional<org.openqa.selenium.devtools.v143.css.model.CSSStyle> inlineStyle;

        private final java.util.Optional<org.openqa.selenium.devtools.v143.css.model.CSSStyle> attributesStyle;

        public GetInlineStylesForNodeResponse(java.util.Optional<org.openqa.selenium.devtools.v143.css.model.CSSStyle> inlineStyle, java.util.Optional<org.openqa.selenium.devtools.v143.css.model.CSSStyle> attributesStyle) {
            this.inlineStyle = inlineStyle;
            this.attributesStyle = attributesStyle;
        }

        /**
         * Inline style for the specified DOM node.
         */
        public java.util.Optional<org.openqa.selenium.devtools.v143.css.model.CSSStyle> getInlineStyle() {
            return inlineStyle;
        }

        /**
         * Attribute-defined element style (e.g. resulting from "width=20 height=100%").
         */
        public java.util.Optional<org.openqa.selenium.devtools.v143.css.model.CSSStyle> getAttributesStyle() {
            return attributesStyle;
        }

        private static GetInlineStylesForNodeResponse fromJson(JsonInput input) {
            java.util.Optional<org.openqa.selenium.devtools.v143.css.model.CSSStyle> inlineStyle = java.util.Optional.empty();
            java.util.Optional<org.openqa.selenium.devtools.v143.css.model.CSSStyle> attributesStyle = java.util.Optional.empty();
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "inlineStyle":
                        inlineStyle = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.css.model.CSSStyle.class));
                        break;
                    case "attributesStyle":
                        attributesStyle = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.css.model.CSSStyle.class));
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new GetInlineStylesForNodeResponse(inlineStyle, attributesStyle);
        }
    }

    /**
     * Returns the styles defined inline (explicitly in the "style" attribute and implicitly, using DOM
     * attributes) for a DOM node identified by `nodeId`.
     */
    public static Command<org.openqa.selenium.devtools.v143.css.CSS.GetInlineStylesForNodeResponse> getInlineStylesForNode(org.openqa.selenium.devtools.v143.dom.model.NodeId nodeId) {
        java.util.Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("nodeId", nodeId);
        return new Command<>("CSS.getInlineStylesForNode", Map.copyOf(params), input -> input.read(org.openqa.selenium.devtools.v143.css.CSS.GetInlineStylesForNodeResponse.class));
    }

    public static class GetAnimatedStylesForNodeResponse {

        private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSAnimationStyle>> animationStyles;

        private final java.util.Optional<org.openqa.selenium.devtools.v143.css.model.CSSStyle> transitionsStyle;

        private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.InheritedAnimatedStyleEntry>> inherited;

        public GetAnimatedStylesForNodeResponse(java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSAnimationStyle>> animationStyles, java.util.Optional<org.openqa.selenium.devtools.v143.css.model.CSSStyle> transitionsStyle, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.InheritedAnimatedStyleEntry>> inherited) {
            this.animationStyles = animationStyles;
            this.transitionsStyle = transitionsStyle;
            this.inherited = inherited;
        }

        /**
         * Styles coming from animations.
         */
        public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSAnimationStyle>> getAnimationStyles() {
            return animationStyles;
        }

        /**
         * Style coming from transitions.
         */
        public java.util.Optional<org.openqa.selenium.devtools.v143.css.model.CSSStyle> getTransitionsStyle() {
            return transitionsStyle;
        }

        /**
         * Inherited style entries for animationsStyle and transitionsStyle from
         * the inheritance chain of the element.
         */
        public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.InheritedAnimatedStyleEntry>> getInherited() {
            return inherited;
        }

        private static GetAnimatedStylesForNodeResponse fromJson(JsonInput input) {
            java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSAnimationStyle>> animationStyles = java.util.Optional.empty();
            java.util.Optional<org.openqa.selenium.devtools.v143.css.model.CSSStyle> transitionsStyle = java.util.Optional.empty();
            java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.InheritedAnimatedStyleEntry>> inherited = java.util.Optional.empty();
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "animationStyles":
                        animationStyles = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v143.css.model.CSSAnimationStyle.class));
                        break;
                    case "transitionsStyle":
                        transitionsStyle = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.css.model.CSSStyle.class));
                        break;
                    case "inherited":
                        inherited = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v143.css.model.InheritedAnimatedStyleEntry.class));
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new GetAnimatedStylesForNodeResponse(animationStyles, transitionsStyle, inherited);
        }
    }

    /**
     * Returns the styles coming from animations & transitions
     * including the animation & transition styles coming from inheritance chain.
     */
    @Beta()
    public static Command<org.openqa.selenium.devtools.v143.css.CSS.GetAnimatedStylesForNodeResponse> getAnimatedStylesForNode(org.openqa.selenium.devtools.v143.dom.model.NodeId nodeId) {
        java.util.Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("nodeId", nodeId);
        return new Command<>("CSS.getAnimatedStylesForNode", Map.copyOf(params), input -> input.read(org.openqa.selenium.devtools.v143.css.CSS.GetAnimatedStylesForNodeResponse.class));
    }

    public static class GetMatchedStylesForNodeResponse {

        private final java.util.Optional<org.openqa.selenium.devtools.v143.css.model.CSSStyle> inlineStyle;

        private final java.util.Optional<org.openqa.selenium.devtools.v143.css.model.CSSStyle> attributesStyle;

        private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.RuleMatch>> matchedCSSRules;

        private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.PseudoElementMatches>> pseudoElements;

        private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.InheritedStyleEntry>> inherited;

        private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.InheritedPseudoElementMatches>> inheritedPseudoElements;

        private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSKeyframesRule>> cssKeyframesRules;

        private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSPositionTryRule>> cssPositionTryRules;

        private final java.util.Optional<java.lang.Integer> activePositionFallbackIndex;

        private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSPropertyRule>> cssPropertyRules;

        private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSPropertyRegistration>> cssPropertyRegistrations;

        private final java.util.Optional<org.openqa.selenium.devtools.v143.css.model.CSSFontPaletteValuesRule> cssFontPaletteValuesRule;

        private final java.util.Optional<org.openqa.selenium.devtools.v143.dom.model.NodeId> parentLayoutNodeId;

        private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSFunctionRule>> cssFunctionRules;

        public GetMatchedStylesForNodeResponse(java.util.Optional<org.openqa.selenium.devtools.v143.css.model.CSSStyle> inlineStyle, java.util.Optional<org.openqa.selenium.devtools.v143.css.model.CSSStyle> attributesStyle, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.RuleMatch>> matchedCSSRules, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.PseudoElementMatches>> pseudoElements, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.InheritedStyleEntry>> inherited, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.InheritedPseudoElementMatches>> inheritedPseudoElements, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSKeyframesRule>> cssKeyframesRules, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSPositionTryRule>> cssPositionTryRules, java.util.Optional<java.lang.Integer> activePositionFallbackIndex, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSPropertyRule>> cssPropertyRules, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSPropertyRegistration>> cssPropertyRegistrations, java.util.Optional<org.openqa.selenium.devtools.v143.css.model.CSSFontPaletteValuesRule> cssFontPaletteValuesRule, java.util.Optional<org.openqa.selenium.devtools.v143.dom.model.NodeId> parentLayoutNodeId, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSFunctionRule>> cssFunctionRules) {
            this.inlineStyle = inlineStyle;
            this.attributesStyle = attributesStyle;
            this.matchedCSSRules = matchedCSSRules;
            this.pseudoElements = pseudoElements;
            this.inherited = inherited;
            this.inheritedPseudoElements = inheritedPseudoElements;
            this.cssKeyframesRules = cssKeyframesRules;
            this.cssPositionTryRules = cssPositionTryRules;
            this.activePositionFallbackIndex = activePositionFallbackIndex;
            this.cssPropertyRules = cssPropertyRules;
            this.cssPropertyRegistrations = cssPropertyRegistrations;
            this.cssFontPaletteValuesRule = cssFontPaletteValuesRule;
            this.parentLayoutNodeId = parentLayoutNodeId;
            this.cssFunctionRules = cssFunctionRules;
        }

        /**
         * Inline style for the specified DOM node.
         */
        public java.util.Optional<org.openqa.selenium.devtools.v143.css.model.CSSStyle> getInlineStyle() {
            return inlineStyle;
        }

        /**
         * Attribute-defined element style (e.g. resulting from "width=20 height=100%").
         */
        public java.util.Optional<org.openqa.selenium.devtools.v143.css.model.CSSStyle> getAttributesStyle() {
            return attributesStyle;
        }

        /**
         * CSS rules matching this node, from all applicable stylesheets.
         */
        public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.RuleMatch>> getMatchedCSSRules() {
            return matchedCSSRules;
        }

        /**
         * Pseudo style matches for this node.
         */
        public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.PseudoElementMatches>> getPseudoElements() {
            return pseudoElements;
        }

        /**
         * A chain of inherited styles (from the immediate node parent up to the DOM tree root).
         */
        public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.InheritedStyleEntry>> getInherited() {
            return inherited;
        }

        /**
         * A chain of inherited pseudo element styles (from the immediate node parent up to the DOM tree root).
         */
        public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.InheritedPseudoElementMatches>> getInheritedPseudoElements() {
            return inheritedPseudoElements;
        }

        /**
         * A list of CSS keyframed animations matching this node.
         */
        public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSKeyframesRule>> getCssKeyframesRules() {
            return cssKeyframesRules;
        }

        /**
         * A list of CSS @position-try rules matching this node, based on the position-try-fallbacks property.
         */
        public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSPositionTryRule>> getCssPositionTryRules() {
            return cssPositionTryRules;
        }

        /**
         * Index of the active fallback in the applied position-try-fallback property,
         * will not be set if there is no active position-try fallback.
         */
        public java.util.Optional<java.lang.Integer> getActivePositionFallbackIndex() {
            return activePositionFallbackIndex;
        }

        /**
         * A list of CSS at-property rules matching this node.
         */
        public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSPropertyRule>> getCssPropertyRules() {
            return cssPropertyRules;
        }

        /**
         * A list of CSS property registrations matching this node.
         */
        public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSPropertyRegistration>> getCssPropertyRegistrations() {
            return cssPropertyRegistrations;
        }

        /**
         * A font-palette-values rule matching this node.
         */
        public java.util.Optional<org.openqa.selenium.devtools.v143.css.model.CSSFontPaletteValuesRule> getCssFontPaletteValuesRule() {
            return cssFontPaletteValuesRule;
        }

        /**
         * Id of the first parent element that does not have display: contents.
         */
        public java.util.Optional<org.openqa.selenium.devtools.v143.dom.model.NodeId> getParentLayoutNodeId() {
            return parentLayoutNodeId;
        }

        /**
         * A list of CSS at-function rules referenced by styles of this node.
         */
        public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSFunctionRule>> getCssFunctionRules() {
            return cssFunctionRules;
        }

        private static GetMatchedStylesForNodeResponse fromJson(JsonInput input) {
            java.util.Optional<org.openqa.selenium.devtools.v143.css.model.CSSStyle> inlineStyle = java.util.Optional.empty();
            java.util.Optional<org.openqa.selenium.devtools.v143.css.model.CSSStyle> attributesStyle = java.util.Optional.empty();
            java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.RuleMatch>> matchedCSSRules = java.util.Optional.empty();
            java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.PseudoElementMatches>> pseudoElements = java.util.Optional.empty();
            java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.InheritedStyleEntry>> inherited = java.util.Optional.empty();
            java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.InheritedPseudoElementMatches>> inheritedPseudoElements = java.util.Optional.empty();
            java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSKeyframesRule>> cssKeyframesRules = java.util.Optional.empty();
            java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSPositionTryRule>> cssPositionTryRules = java.util.Optional.empty();
            java.util.Optional<java.lang.Integer> activePositionFallbackIndex = java.util.Optional.empty();
            java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSPropertyRule>> cssPropertyRules = java.util.Optional.empty();
            java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSPropertyRegistration>> cssPropertyRegistrations = java.util.Optional.empty();
            java.util.Optional<org.openqa.selenium.devtools.v143.css.model.CSSFontPaletteValuesRule> cssFontPaletteValuesRule = java.util.Optional.empty();
            java.util.Optional<org.openqa.selenium.devtools.v143.dom.model.NodeId> parentLayoutNodeId = java.util.Optional.empty();
            java.util.Optional<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSFunctionRule>> cssFunctionRules = java.util.Optional.empty();
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "inlineStyle":
                        inlineStyle = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.css.model.CSSStyle.class));
                        break;
                    case "attributesStyle":
                        attributesStyle = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.css.model.CSSStyle.class));
                        break;
                    case "matchedCSSRules":
                        matchedCSSRules = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v143.css.model.RuleMatch.class));
                        break;
                    case "pseudoElements":
                        pseudoElements = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v143.css.model.PseudoElementMatches.class));
                        break;
                    case "inherited":
                        inherited = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v143.css.model.InheritedStyleEntry.class));
                        break;
                    case "inheritedPseudoElements":
                        inheritedPseudoElements = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v143.css.model.InheritedPseudoElementMatches.class));
                        break;
                    case "cssKeyframesRules":
                        cssKeyframesRules = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v143.css.model.CSSKeyframesRule.class));
                        break;
                    case "cssPositionTryRules":
                        cssPositionTryRules = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v143.css.model.CSSPositionTryRule.class));
                        break;
                    case "activePositionFallbackIndex":
                        activePositionFallbackIndex = java.util.Optional.ofNullable(input.nextNumber().intValue());
                        break;
                    case "cssPropertyRules":
                        cssPropertyRules = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v143.css.model.CSSPropertyRule.class));
                        break;
                    case "cssPropertyRegistrations":
                        cssPropertyRegistrations = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v143.css.model.CSSPropertyRegistration.class));
                        break;
                    case "cssFontPaletteValuesRule":
                        cssFontPaletteValuesRule = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.css.model.CSSFontPaletteValuesRule.class));
                        break;
                    case "parentLayoutNodeId":
                        parentLayoutNodeId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.dom.model.NodeId.class));
                        break;
                    case "cssFunctionRules":
                        cssFunctionRules = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v143.css.model.CSSFunctionRule.class));
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new GetMatchedStylesForNodeResponse(inlineStyle, attributesStyle, matchedCSSRules, pseudoElements, inherited, inheritedPseudoElements, cssKeyframesRules, cssPositionTryRules, activePositionFallbackIndex, cssPropertyRules, cssPropertyRegistrations, cssFontPaletteValuesRule, parentLayoutNodeId, cssFunctionRules);
        }
    }

    /**
     * Returns requested styles for a DOM node identified by `nodeId`.
     */
    public static Command<org.openqa.selenium.devtools.v143.css.CSS.GetMatchedStylesForNodeResponse> getMatchedStylesForNode(org.openqa.selenium.devtools.v143.dom.model.NodeId nodeId) {
        java.util.Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("nodeId", nodeId);
        return new Command<>("CSS.getMatchedStylesForNode", Map.copyOf(params), input -> input.read(org.openqa.selenium.devtools.v143.css.CSS.GetMatchedStylesForNodeResponse.class));
    }

    /**
     * Returns the values of the default UA-defined environment variables used in env()
     */
    @Beta()
    public static Command<java.util.Map<String, Object>> getEnvironmentVariables() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("CSS.getEnvironmentVariables", Map.copyOf(params), ConverterFunctions.map("environmentVariables", java.util.Map.class));
    }

    /**
     * Returns all media queries parsed by the rendering engine.
     */
    public static Command<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSMedia>> getMediaQueries() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("CSS.getMediaQueries", Map.copyOf(params), ConverterFunctions.map("medias", input -> input.readArray(org.openqa.selenium.devtools.v143.css.model.CSSMedia.class)));
    }

    /**
     * Requests information about platform fonts which we used to render child TextNodes in the given
     * node.
     */
    public static Command<java.util.List<org.openqa.selenium.devtools.v143.css.model.PlatformFontUsage>> getPlatformFontsForNode(org.openqa.selenium.devtools.v143.dom.model.NodeId nodeId) {
        java.util.Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("nodeId", nodeId);
        return new Command<>("CSS.getPlatformFontsForNode", Map.copyOf(params), ConverterFunctions.map("fonts", input -> input.readArray(org.openqa.selenium.devtools.v143.css.model.PlatformFontUsage.class)));
    }

    /**
     * Returns the current textual content for a stylesheet.
     */
    public static Command<java.lang.String> getStyleSheetText(org.openqa.selenium.devtools.v143.css.model.StyleSheetId styleSheetId) {
        java.util.Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("styleSheetId", styleSheetId);
        return new Command<>("CSS.getStyleSheetText", Map.copyOf(params), ConverterFunctions.map("text", java.lang.String.class));
    }

    /**
     * Returns all layers parsed by the rendering engine for the tree scope of a node.
     * Given a DOM element identified by nodeId, getLayersForNode returns the root
     * layer for the nearest ancestor document or shadow root. The layer root contains
     * the full layer tree for the tree scope and their ordering.
     */
    @Beta()
    public static Command<org.openqa.selenium.devtools.v143.css.model.CSSLayerData> getLayersForNode(org.openqa.selenium.devtools.v143.dom.model.NodeId nodeId) {
        java.util.Objects.requireNonNull(nodeId, "nodeId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("nodeId", nodeId);
        return new Command<>("CSS.getLayersForNode", Map.copyOf(params), ConverterFunctions.map("rootLayer", org.openqa.selenium.devtools.v143.css.model.CSSLayerData.class));
    }

    /**
     * Given a CSS selector text and a style sheet ID, getLocationForSelector
     * returns an array of locations of the CSS selector in the style sheet.
     */
    @Beta()
    public static Command<java.util.List<org.openqa.selenium.devtools.v143.css.model.SourceRange>> getLocationForSelector(org.openqa.selenium.devtools.v143.css.model.StyleSheetId styleSheetId, java.lang.String selectorText) {
        java.util.Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        java.util.Objects.requireNonNull(selectorText, "selectorText is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("styleSheetId", styleSheetId);
        params.put("selectorText", selectorText);
        return new Command<>("CSS.getLocationForSelector", Map.copyOf(params), ConverterFunctions.map("ranges", input -> input.readArray(org.openqa.selenium.devtools.v143.css.model.SourceRange.class)));
    }

    /**
     * Starts tracking the given node for the computed style updates
     * and whenever the computed style is updated for node, it queues
     * a `computedStyleUpdated` event with throttling.
     * There can only be 1 node tracked for computed style updates
     * so passing a new node id removes tracking from the previous node.
     * Pass `undefined` to disable tracking.
     */
    @Beta()
    public static Command<Void> trackComputedStyleUpdatesForNode(java.util.Optional<org.openqa.selenium.devtools.v143.dom.model.NodeId> nodeId) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        return new Command<>("CSS.trackComputedStyleUpdatesForNode", Map.copyOf(params));
    }

    /**
     * Starts tracking the given computed styles for updates. The specified array of properties
     * replaces the one previously specified. Pass empty array to disable tracking.
     * Use takeComputedStyleUpdates to retrieve the list of nodes that had properties modified.
     * The changes to computed style properties are only tracked for nodes pushed to the front-end
     * by the DOM agent. If no changes to the tracked properties occur after the node has been pushed
     * to the front-end, no updates will be issued for the node.
     */
    @Beta()
    public static Command<Void> trackComputedStyleUpdates(java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSComputedStyleProperty> propertiesToTrack) {
        java.util.Objects.requireNonNull(propertiesToTrack, "propertiesToTrack is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("propertiesToTrack", propertiesToTrack);
        return new Command<>("CSS.trackComputedStyleUpdates", Map.copyOf(params));
    }

    /**
     * Polls the next batch of computed style updates.
     */
    @Beta()
    public static Command<java.util.List<org.openqa.selenium.devtools.v143.dom.model.NodeId>> takeComputedStyleUpdates() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("CSS.takeComputedStyleUpdates", Map.copyOf(params), ConverterFunctions.map("nodeIds", input -> input.readArray(org.openqa.selenium.devtools.v143.dom.model.NodeId.class)));
    }

    /**
     * Find a rule with the given active property for the given node and set the new value for this
     * property
     */
    public static Command<Void> setEffectivePropertyValueForNode(org.openqa.selenium.devtools.v143.dom.model.NodeId nodeId, java.lang.String propertyName, java.lang.String value) {
        java.util.Objects.requireNonNull(nodeId, "nodeId is required");
        java.util.Objects.requireNonNull(propertyName, "propertyName is required");
        java.util.Objects.requireNonNull(value, "value is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("nodeId", nodeId);
        params.put("propertyName", propertyName);
        params.put("value", value);
        return new Command<>("CSS.setEffectivePropertyValueForNode", Map.copyOf(params));
    }

    /**
     * Modifies the property rule property name.
     */
    public static Command<org.openqa.selenium.devtools.v143.css.model.Value> setPropertyRulePropertyName(org.openqa.selenium.devtools.v143.css.model.StyleSheetId styleSheetId, org.openqa.selenium.devtools.v143.css.model.SourceRange range, java.lang.String propertyName) {
        java.util.Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        java.util.Objects.requireNonNull(range, "range is required");
        java.util.Objects.requireNonNull(propertyName, "propertyName is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("styleSheetId", styleSheetId);
        params.put("range", range);
        params.put("propertyName", propertyName);
        return new Command<>("CSS.setPropertyRulePropertyName", Map.copyOf(params), ConverterFunctions.map("propertyName", org.openqa.selenium.devtools.v143.css.model.Value.class));
    }

    /**
     * Modifies the keyframe rule key text.
     */
    public static Command<org.openqa.selenium.devtools.v143.css.model.Value> setKeyframeKey(org.openqa.selenium.devtools.v143.css.model.StyleSheetId styleSheetId, org.openqa.selenium.devtools.v143.css.model.SourceRange range, java.lang.String keyText) {
        java.util.Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        java.util.Objects.requireNonNull(range, "range is required");
        java.util.Objects.requireNonNull(keyText, "keyText is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("styleSheetId", styleSheetId);
        params.put("range", range);
        params.put("keyText", keyText);
        return new Command<>("CSS.setKeyframeKey", Map.copyOf(params), ConverterFunctions.map("keyText", org.openqa.selenium.devtools.v143.css.model.Value.class));
    }

    /**
     * Modifies the rule selector.
     */
    public static Command<org.openqa.selenium.devtools.v143.css.model.CSSMedia> setMediaText(org.openqa.selenium.devtools.v143.css.model.StyleSheetId styleSheetId, org.openqa.selenium.devtools.v143.css.model.SourceRange range, java.lang.String text) {
        java.util.Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        java.util.Objects.requireNonNull(range, "range is required");
        java.util.Objects.requireNonNull(text, "text is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("styleSheetId", styleSheetId);
        params.put("range", range);
        params.put("text", text);
        return new Command<>("CSS.setMediaText", Map.copyOf(params), ConverterFunctions.map("media", org.openqa.selenium.devtools.v143.css.model.CSSMedia.class));
    }

    /**
     * Modifies the expression of a container query.
     */
    @Beta()
    public static Command<org.openqa.selenium.devtools.v143.css.model.CSSContainerQuery> setContainerQueryText(org.openqa.selenium.devtools.v143.css.model.StyleSheetId styleSheetId, org.openqa.selenium.devtools.v143.css.model.SourceRange range, java.lang.String text) {
        java.util.Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        java.util.Objects.requireNonNull(range, "range is required");
        java.util.Objects.requireNonNull(text, "text is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("styleSheetId", styleSheetId);
        params.put("range", range);
        params.put("text", text);
        return new Command<>("CSS.setContainerQueryText", Map.copyOf(params), ConverterFunctions.map("containerQuery", org.openqa.selenium.devtools.v143.css.model.CSSContainerQuery.class));
    }

    /**
     * Modifies the expression of a supports at-rule.
     */
    @Beta()
    public static Command<org.openqa.selenium.devtools.v143.css.model.CSSSupports> setSupportsText(org.openqa.selenium.devtools.v143.css.model.StyleSheetId styleSheetId, org.openqa.selenium.devtools.v143.css.model.SourceRange range, java.lang.String text) {
        java.util.Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        java.util.Objects.requireNonNull(range, "range is required");
        java.util.Objects.requireNonNull(text, "text is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("styleSheetId", styleSheetId);
        params.put("range", range);
        params.put("text", text);
        return new Command<>("CSS.setSupportsText", Map.copyOf(params), ConverterFunctions.map("supports", org.openqa.selenium.devtools.v143.css.model.CSSSupports.class));
    }

    /**
     * Modifies the expression of a scope at-rule.
     */
    @Beta()
    public static Command<org.openqa.selenium.devtools.v143.css.model.CSSScope> setScopeText(org.openqa.selenium.devtools.v143.css.model.StyleSheetId styleSheetId, org.openqa.selenium.devtools.v143.css.model.SourceRange range, java.lang.String text) {
        java.util.Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        java.util.Objects.requireNonNull(range, "range is required");
        java.util.Objects.requireNonNull(text, "text is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("styleSheetId", styleSheetId);
        params.put("range", range);
        params.put("text", text);
        return new Command<>("CSS.setScopeText", Map.copyOf(params), ConverterFunctions.map("scope", org.openqa.selenium.devtools.v143.css.model.CSSScope.class));
    }

    /**
     * Modifies the rule selector.
     */
    public static Command<org.openqa.selenium.devtools.v143.css.model.SelectorList> setRuleSelector(org.openqa.selenium.devtools.v143.css.model.StyleSheetId styleSheetId, org.openqa.selenium.devtools.v143.css.model.SourceRange range, java.lang.String selector) {
        java.util.Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        java.util.Objects.requireNonNull(range, "range is required");
        java.util.Objects.requireNonNull(selector, "selector is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("styleSheetId", styleSheetId);
        params.put("range", range);
        params.put("selector", selector);
        return new Command<>("CSS.setRuleSelector", Map.copyOf(params), ConverterFunctions.map("selectorList", org.openqa.selenium.devtools.v143.css.model.SelectorList.class));
    }

    /**
     * Sets the new stylesheet text.
     */
    public static Command<java.lang.String> setStyleSheetText(org.openqa.selenium.devtools.v143.css.model.StyleSheetId styleSheetId, java.lang.String text) {
        java.util.Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        java.util.Objects.requireNonNull(text, "text is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("styleSheetId", styleSheetId);
        params.put("text", text);
        return new Command<>("CSS.setStyleSheetText", Map.copyOf(params), ConverterFunctions.map("sourceMapURL", java.lang.String.class));
    }

    /**
     * Applies specified style edits one after another in the given order.
     */
    public static Command<java.util.List<org.openqa.selenium.devtools.v143.css.model.CSSStyle>> setStyleTexts(java.util.List<org.openqa.selenium.devtools.v143.css.model.StyleDeclarationEdit> edits, java.util.Optional<org.openqa.selenium.devtools.v143.dom.model.NodeId> nodeForPropertySyntaxValidation) {
        java.util.Objects.requireNonNull(edits, "edits is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("edits", edits);
        nodeForPropertySyntaxValidation.ifPresent(p -> params.put("nodeForPropertySyntaxValidation", p));
        return new Command<>("CSS.setStyleTexts", Map.copyOf(params), ConverterFunctions.map("styles", input -> input.readArray(org.openqa.selenium.devtools.v143.css.model.CSSStyle.class)));
    }

    /**
     * Enables the selector recording.
     */
    public static Command<Void> startRuleUsageTracking() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("CSS.startRuleUsageTracking", Map.copyOf(params));
    }

    /**
     * Stop tracking rule usage and return the list of rules that were used since last call to
     * `takeCoverageDelta` (or since start of coverage instrumentation).
     */
    public static Command<java.util.List<org.openqa.selenium.devtools.v143.css.model.RuleUsage>> stopRuleUsageTracking() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("CSS.stopRuleUsageTracking", Map.copyOf(params), ConverterFunctions.map("ruleUsage", input -> input.readArray(org.openqa.selenium.devtools.v143.css.model.RuleUsage.class)));
    }

    public static class TakeCoverageDeltaResponse {

        private final java.util.List<org.openqa.selenium.devtools.v143.css.model.RuleUsage> coverage;

        private final java.lang.Number timestamp;

        public TakeCoverageDeltaResponse(java.util.List<org.openqa.selenium.devtools.v143.css.model.RuleUsage> coverage, java.lang.Number timestamp) {
            this.coverage = java.util.Objects.requireNonNull(coverage, "coverage is required");
            this.timestamp = java.util.Objects.requireNonNull(timestamp, "timestamp is required");
        }

        public java.util.List<org.openqa.selenium.devtools.v143.css.model.RuleUsage> getCoverage() {
            return coverage;
        }

        /**
         * Monotonically increasing time, in seconds.
         */
        public java.lang.Number getTimestamp() {
            return timestamp;
        }

        private static TakeCoverageDeltaResponse fromJson(JsonInput input) {
            java.util.List<org.openqa.selenium.devtools.v143.css.model.RuleUsage> coverage = null;
            java.lang.Number timestamp = 0;
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "coverage":
                        coverage = input.readArray(org.openqa.selenium.devtools.v143.css.model.RuleUsage.class);
                        break;
                    case "timestamp":
                        timestamp = input.nextNumber();
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new TakeCoverageDeltaResponse(coverage, timestamp);
        }
    }

    /**
     * Obtain list of rules that became used since last call to this method (or since start of coverage
     * instrumentation).
     */
    public static Command<org.openqa.selenium.devtools.v143.css.CSS.TakeCoverageDeltaResponse> takeCoverageDelta() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("CSS.takeCoverageDelta", Map.copyOf(params), input -> input.read(org.openqa.selenium.devtools.v143.css.CSS.TakeCoverageDeltaResponse.class));
    }

    /**
     * Enables/disables rendering of local CSS fonts (enabled by default).
     */
    @Beta()
    public static Command<Void> setLocalFontsEnabled(java.lang.Boolean enabled) {
        java.util.Objects.requireNonNull(enabled, "enabled is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("enabled", enabled);
        return new Command<>("CSS.setLocalFontsEnabled", Map.copyOf(params));
    }

    public static Event<org.openqa.selenium.devtools.v143.css.model.FontFace> fontsUpdated() {
        return new Event<>("CSS.fontsUpdated", ConverterFunctions.map("font", org.openqa.selenium.devtools.v143.css.model.FontFace.class));
    }

    public static Event<Void> mediaQueryResultChanged() {
        return new Event<>("CSS.mediaQueryResultChanged", ConverterFunctions.empty());
    }

    public static Event<org.openqa.selenium.devtools.v143.css.model.CSSStyleSheetHeader> styleSheetAdded() {
        return new Event<>("CSS.styleSheetAdded", ConverterFunctions.map("header", org.openqa.selenium.devtools.v143.css.model.CSSStyleSheetHeader.class));
    }

    public static Event<org.openqa.selenium.devtools.v143.css.model.StyleSheetId> styleSheetChanged() {
        return new Event<>("CSS.styleSheetChanged", ConverterFunctions.map("styleSheetId", org.openqa.selenium.devtools.v143.css.model.StyleSheetId.class));
    }

    public static Event<org.openqa.selenium.devtools.v143.css.model.StyleSheetId> styleSheetRemoved() {
        return new Event<>("CSS.styleSheetRemoved", ConverterFunctions.map("styleSheetId", org.openqa.selenium.devtools.v143.css.model.StyleSheetId.class));
    }

    public static Event<org.openqa.selenium.devtools.v143.dom.model.NodeId> computedStyleUpdated() {
        return new Event<>("CSS.computedStyleUpdated", ConverterFunctions.map("nodeId", org.openqa.selenium.devtools.v143.dom.model.NodeId.class));
    }
}
