package org.openqa.selenium.devtools.v143.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class BlockPattern {

    private final java.lang.String urlPattern;

    private final java.lang.Boolean block;

    public BlockPattern(java.lang.String urlPattern, java.lang.Boolean block) {
        this.urlPattern = java.util.Objects.requireNonNull(urlPattern, "urlPattern is required");
        this.block = java.util.Objects.requireNonNull(block, "block is required");
    }

    /**
     * URL pattern to match. Patterns use the URLPattern constructor string syntax
     * (https://urlpattern.spec.whatwg.org/) and must be absolute.
     */
    public java.lang.String getUrlPattern() {
        return urlPattern;
    }

    /**
     * Whether or not to block the pattern. If false, a matching request will not be blocked even if it matches a later
     * `BlockPattern`.
     */
    public java.lang.Boolean getBlock() {
        return block;
    }

    private static BlockPattern fromJson(JsonInput input) {
        java.lang.String urlPattern = null;
        java.lang.Boolean block = false;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "urlPattern":
                    urlPattern = input.nextString();
                    break;
                case "block":
                    block = input.nextBoolean();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new BlockPattern(urlPattern, block);
    }
}
