package org.openqa.selenium.devtools.v143.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class DirectUDPMessage {

    private final java.lang.String data;

    private final java.util.Optional<java.lang.String> remoteAddr;

    private final java.util.Optional<java.lang.Integer> remotePort;

    public DirectUDPMessage(java.lang.String data, java.util.Optional<java.lang.String> remoteAddr, java.util.Optional<java.lang.Integer> remotePort) {
        this.data = java.util.Objects.requireNonNull(data, "data is required");
        this.remoteAddr = remoteAddr;
        this.remotePort = remotePort;
    }

    public java.lang.String getData() {
        return data;
    }

    /**
     * Null for connected mode.
     */
    public java.util.Optional<java.lang.String> getRemoteAddr() {
        return remoteAddr;
    }

    /**
     * Null for connected mode.
     * Expected to be unsigned integer.
     */
    public java.util.Optional<java.lang.Integer> getRemotePort() {
        return remotePort;
    }

    private static DirectUDPMessage fromJson(JsonInput input) {
        java.lang.String data = null;
        java.util.Optional<java.lang.String> remoteAddr = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> remotePort = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "data":
                    data = input.nextString();
                    break;
                case "remoteAddr":
                    remoteAddr = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "remotePort":
                    remotePort = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DirectUDPMessage(data, remoteAddr, remotePort);
    }
}
