package org.openqa.selenium.devtools.v143.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class NetworkConditions {

    private final java.lang.String urlPattern;

    private final java.lang.Number latency;

    private final java.lang.Number downloadThroughput;

    private final java.lang.Number uploadThroughput;

    private final java.util.Optional<org.openqa.selenium.devtools.v143.network.model.ConnectionType> connectionType;

    private final java.util.Optional<java.lang.Number> packetLoss;

    private final java.util.Optional<java.lang.Integer> packetQueueLength;

    private final java.util.Optional<java.lang.Boolean> packetReordering;

    public NetworkConditions(java.lang.String urlPattern, java.lang.Number latency, java.lang.Number downloadThroughput, java.lang.Number uploadThroughput, java.util.Optional<org.openqa.selenium.devtools.v143.network.model.ConnectionType> connectionType, java.util.Optional<java.lang.Number> packetLoss, java.util.Optional<java.lang.Integer> packetQueueLength, java.util.Optional<java.lang.Boolean> packetReordering) {
        this.urlPattern = java.util.Objects.requireNonNull(urlPattern, "urlPattern is required");
        this.latency = java.util.Objects.requireNonNull(latency, "latency is required");
        this.downloadThroughput = java.util.Objects.requireNonNull(downloadThroughput, "downloadThroughput is required");
        this.uploadThroughput = java.util.Objects.requireNonNull(uploadThroughput, "uploadThroughput is required");
        this.connectionType = connectionType;
        this.packetLoss = packetLoss;
        this.packetQueueLength = packetQueueLength;
        this.packetReordering = packetReordering;
    }

    /**
     * Only matching requests will be affected by these conditions. Patterns use the URLPattern constructor string
     * syntax (https://urlpattern.spec.whatwg.org/) and must be absolute. If the pattern is empty, all requests are
     * matched (including p2p connections).
     */
    public java.lang.String getUrlPattern() {
        return urlPattern;
    }

    /**
     * Minimum latency from request sent to response headers received (ms).
     */
    public java.lang.Number getLatency() {
        return latency;
    }

    /**
     * Maximal aggregated download throughput (bytes/sec). -1 disables download throttling.
     */
    public java.lang.Number getDownloadThroughput() {
        return downloadThroughput;
    }

    /**
     * Maximal aggregated upload throughput (bytes/sec).  -1 disables upload throttling.
     */
    public java.lang.Number getUploadThroughput() {
        return uploadThroughput;
    }

    /**
     * Connection type if known.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v143.network.model.ConnectionType> getConnectionType() {
        return connectionType;
    }

    /**
     * WebRTC packet loss (percent, 0-100). 0 disables packet loss emulation, 100 drops all the packets.
     */
    public java.util.Optional<java.lang.Number> getPacketLoss() {
        return packetLoss;
    }

    /**
     * WebRTC packet queue length (packet). 0 removes any queue length limitations.
     */
    public java.util.Optional<java.lang.Integer> getPacketQueueLength() {
        return packetQueueLength;
    }

    /**
     * WebRTC packetReordering feature.
     */
    public java.util.Optional<java.lang.Boolean> getPacketReordering() {
        return packetReordering;
    }

    private static NetworkConditions fromJson(JsonInput input) {
        java.lang.String urlPattern = null;
        java.lang.Number latency = 0;
        java.lang.Number downloadThroughput = 0;
        java.lang.Number uploadThroughput = 0;
        java.util.Optional<org.openqa.selenium.devtools.v143.network.model.ConnectionType> connectionType = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> packetLoss = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> packetQueueLength = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> packetReordering = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "urlPattern":
                    urlPattern = input.nextString();
                    break;
                case "latency":
                    latency = input.nextNumber();
                    break;
                case "downloadThroughput":
                    downloadThroughput = input.nextNumber();
                    break;
                case "uploadThroughput":
                    uploadThroughput = input.nextNumber();
                    break;
                case "connectionType":
                    connectionType = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.network.model.ConnectionType.class));
                    break;
                case "packetLoss":
                    packetLoss = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "packetQueueLength":
                    packetQueueLength = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "packetReordering":
                    packetReordering = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new NetworkConditions(urlPattern, latency, downloadThroughput, uploadThroughput, connectionType, packetLoss, packetQueueLength, packetReordering);
    }
}
