package org.openqa.selenium.devtools.v143.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class PermissionsPolicyFeatureState {

    private final org.openqa.selenium.devtools.v143.page.model.PermissionsPolicyFeature feature;

    private final java.lang.Boolean allowed;

    private final java.util.Optional<org.openqa.selenium.devtools.v143.page.model.PermissionsPolicyBlockLocator> locator;

    public PermissionsPolicyFeatureState(org.openqa.selenium.devtools.v143.page.model.PermissionsPolicyFeature feature, java.lang.Boolean allowed, java.util.Optional<org.openqa.selenium.devtools.v143.page.model.PermissionsPolicyBlockLocator> locator) {
        this.feature = java.util.Objects.requireNonNull(feature, "feature is required");
        this.allowed = java.util.Objects.requireNonNull(allowed, "allowed is required");
        this.locator = locator;
    }

    public org.openqa.selenium.devtools.v143.page.model.PermissionsPolicyFeature getFeature() {
        return feature;
    }

    public java.lang.Boolean getAllowed() {
        return allowed;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v143.page.model.PermissionsPolicyBlockLocator> getLocator() {
        return locator;
    }

    private static PermissionsPolicyFeatureState fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v143.page.model.PermissionsPolicyFeature feature = null;
        java.lang.Boolean allowed = false;
        java.util.Optional<org.openqa.selenium.devtools.v143.page.model.PermissionsPolicyBlockLocator> locator = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "feature":
                    feature = input.read(org.openqa.selenium.devtools.v143.page.model.PermissionsPolicyFeature.class);
                    break;
                case "allowed":
                    allowed = input.nextBoolean();
                    break;
                case "locator":
                    locator = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.page.model.PermissionsPolicyBlockLocator.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PermissionsPolicyFeatureState(feature, allowed, locator);
    }
}
