package org.openqa.selenium.devtools.v143.performancetimeline.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * See https://github.com/WICG/LargestContentfulPaint and largest_contentful_paint.idl
 */
public class LargestContentfulPaint {

    private final org.openqa.selenium.devtools.v143.network.model.TimeSinceEpoch renderTime;

    private final org.openqa.selenium.devtools.v143.network.model.TimeSinceEpoch loadTime;

    private final java.lang.Number size;

    private final java.util.Optional<java.lang.String> elementId;

    private final java.util.Optional<java.lang.String> url;

    private final java.util.Optional<org.openqa.selenium.devtools.v143.dom.model.BackendNodeId> nodeId;

    public LargestContentfulPaint(org.openqa.selenium.devtools.v143.network.model.TimeSinceEpoch renderTime, org.openqa.selenium.devtools.v143.network.model.TimeSinceEpoch loadTime, java.lang.Number size, java.util.Optional<java.lang.String> elementId, java.util.Optional<java.lang.String> url, java.util.Optional<org.openqa.selenium.devtools.v143.dom.model.BackendNodeId> nodeId) {
        this.renderTime = java.util.Objects.requireNonNull(renderTime, "renderTime is required");
        this.loadTime = java.util.Objects.requireNonNull(loadTime, "loadTime is required");
        this.size = java.util.Objects.requireNonNull(size, "size is required");
        this.elementId = elementId;
        this.url = url;
        this.nodeId = nodeId;
    }

    public org.openqa.selenium.devtools.v143.network.model.TimeSinceEpoch getRenderTime() {
        return renderTime;
    }

    public org.openqa.selenium.devtools.v143.network.model.TimeSinceEpoch getLoadTime() {
        return loadTime;
    }

    /**
     * The number of pixels being painted.
     */
    public java.lang.Number getSize() {
        return size;
    }

    /**
     * The id attribute of the element, if available.
     */
    public java.util.Optional<java.lang.String> getElementId() {
        return elementId;
    }

    /**
     * The URL of the image (may be trimmed).
     */
    public java.util.Optional<java.lang.String> getUrl() {
        return url;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v143.dom.model.BackendNodeId> getNodeId() {
        return nodeId;
    }

    private static LargestContentfulPaint fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v143.network.model.TimeSinceEpoch renderTime = null;
        org.openqa.selenium.devtools.v143.network.model.TimeSinceEpoch loadTime = null;
        java.lang.Number size = 0;
        java.util.Optional<java.lang.String> elementId = java.util.Optional.empty();
        java.util.Optional<java.lang.String> url = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v143.dom.model.BackendNodeId> nodeId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "renderTime":
                    renderTime = input.read(org.openqa.selenium.devtools.v143.network.model.TimeSinceEpoch.class);
                    break;
                case "loadTime":
                    loadTime = input.read(org.openqa.selenium.devtools.v143.network.model.TimeSinceEpoch.class);
                    break;
                case "size":
                    size = input.nextNumber();
                    break;
                case "elementId":
                    elementId = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "url":
                    url = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "nodeId":
                    nodeId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v143.dom.model.BackendNodeId.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new LargestContentfulPaint(renderTime, loadTime, size, elementId, url, nodeId);
    }
}
