package org.openqa.selenium.devtools.v143.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Enum of shared storage access methods.
 */
public enum SharedStorageAccessMethod {

    ADDMODULE("addModule"),
    CREATEWORKLET("createWorklet"),
    SELECTURL("selectURL"),
    RUN("run"),
    BATCHUPDATE("batchUpdate"),
    SET("set"),
    APPEND("append"),
    DELETE("delete"),
    CLEAR("clear"),
    GET("get"),
    KEYS("keys"),
    VALUES("values"),
    ENTRIES("entries"),
    LENGTH("length"),
    REMAININGBUDGET("remainingBudget");

    private String value;

    SharedStorageAccessMethod(String value) {
        this.value = value;
    }

    public static SharedStorageAccessMethod fromString(String s) {
        return java.util.Arrays.stream(SharedStorageAccessMethod.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within SharedStorageAccessMethod "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static SharedStorageAccessMethod fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
