package org.openqa.selenium.devtools.v144.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * This issue warns about errors in the select or summary element content model.
 */
public class ElementAccessibilityIssueDetails {

    private final org.openqa.selenium.devtools.v144.dom.model.BackendNodeId nodeId;

    private final org.openqa.selenium.devtools.v144.audits.model.ElementAccessibilityIssueReason elementAccessibilityIssueReason;

    private final java.lang.Boolean hasDisallowedAttributes;

    public ElementAccessibilityIssueDetails(org.openqa.selenium.devtools.v144.dom.model.BackendNodeId nodeId, org.openqa.selenium.devtools.v144.audits.model.ElementAccessibilityIssueReason elementAccessibilityIssueReason, java.lang.Boolean hasDisallowedAttributes) {
        this.nodeId = java.util.Objects.requireNonNull(nodeId, "nodeId is required");
        this.elementAccessibilityIssueReason = java.util.Objects.requireNonNull(elementAccessibilityIssueReason, "elementAccessibilityIssueReason is required");
        this.hasDisallowedAttributes = java.util.Objects.requireNonNull(hasDisallowedAttributes, "hasDisallowedAttributes is required");
    }

    public org.openqa.selenium.devtools.v144.dom.model.BackendNodeId getNodeId() {
        return nodeId;
    }

    public org.openqa.selenium.devtools.v144.audits.model.ElementAccessibilityIssueReason getElementAccessibilityIssueReason() {
        return elementAccessibilityIssueReason;
    }

    public java.lang.Boolean getHasDisallowedAttributes() {
        return hasDisallowedAttributes;
    }

    private static ElementAccessibilityIssueDetails fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v144.dom.model.BackendNodeId nodeId = null;
        org.openqa.selenium.devtools.v144.audits.model.ElementAccessibilityIssueReason elementAccessibilityIssueReason = null;
        java.lang.Boolean hasDisallowedAttributes = false;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "nodeId":
                    nodeId = input.read(org.openqa.selenium.devtools.v144.dom.model.BackendNodeId.class);
                    break;
                case "elementAccessibilityIssueReason":
                    elementAccessibilityIssueReason = input.read(org.openqa.selenium.devtools.v144.audits.model.ElementAccessibilityIssueReason.class);
                    break;
                case "hasDisallowedAttributes":
                    hasDisallowedAttributes = input.nextBoolean();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ElementAccessibilityIssueDetails(nodeId, elementAccessibilityIssueReason, hasDisallowedAttributes);
    }
}
