package org.openqa.selenium.devtools.v144.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * CSS generic @rule representation.
 */
public class CSSAtRule {

    public enum Type {

        FONT_FACE("font-face"), FONT_FEATURE_VALUES("font-feature-values"), FONT_PALETTE_VALUES("font-palette-values");

        private String value;

        Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return java.util.Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static Type fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    public enum Subsection {

        SWASH("swash"),
        ANNOTATION("annotation"),
        ORNAMENTS("ornaments"),
        STYLISTIC("stylistic"),
        STYLESET("styleset"),
        CHARACTER_VARIANT("character-variant");

        private String value;

        Subsection(String value) {
            this.value = value;
        }

        public static Subsection fromString(String s) {
            return java.util.Arrays.stream(Subsection.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within Subsection "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static Subsection fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final Type type;

    private final java.util.Optional<Subsection> subsection;

    private final java.util.Optional<org.openqa.selenium.devtools.v144.css.model.Value> name;

    private final java.util.Optional<org.openqa.selenium.devtools.v144.dom.model.StyleSheetId> styleSheetId;

    private final org.openqa.selenium.devtools.v144.css.model.StyleSheetOrigin origin;

    private final org.openqa.selenium.devtools.v144.css.model.CSSStyle style;

    public CSSAtRule(Type type, java.util.Optional<Subsection> subsection, java.util.Optional<org.openqa.selenium.devtools.v144.css.model.Value> name, java.util.Optional<org.openqa.selenium.devtools.v144.dom.model.StyleSheetId> styleSheetId, org.openqa.selenium.devtools.v144.css.model.StyleSheetOrigin origin, org.openqa.selenium.devtools.v144.css.model.CSSStyle style) {
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.subsection = subsection;
        this.name = name;
        this.styleSheetId = styleSheetId;
        this.origin = java.util.Objects.requireNonNull(origin, "origin is required");
        this.style = java.util.Objects.requireNonNull(style, "style is required");
    }

    /**
     * Type of at-rule.
     */
    public Type getType() {
        return type;
    }

    /**
     * Subsection of font-feature-values, if this is a subsection.
     */
    public java.util.Optional<Subsection> getSubsection() {
        return subsection;
    }

    /**
     * LINT.ThenChange(//third_party/blink/renderer/core/inspector/inspector_style_sheet.cc:FontVariantAlternatesFeatureType,//third_party/blink/renderer/core/inspector/inspector_css_agent.cc:FontVariantAlternatesFeatureType)
     * Associated name, if applicable.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v144.css.model.Value> getName() {
        return name;
    }

    /**
     * The css style sheet identifier (absent for user agent stylesheet and user-specified
     * stylesheet rules) this rule came from.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v144.dom.model.StyleSheetId> getStyleSheetId() {
        return styleSheetId;
    }

    /**
     * Parent stylesheet's origin.
     */
    public org.openqa.selenium.devtools.v144.css.model.StyleSheetOrigin getOrigin() {
        return origin;
    }

    /**
     * Associated style declaration.
     */
    public org.openqa.selenium.devtools.v144.css.model.CSSStyle getStyle() {
        return style;
    }

    private static CSSAtRule fromJson(JsonInput input) {
        Type type = null;
        java.util.Optional<Subsection> subsection = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v144.css.model.Value> name = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v144.dom.model.StyleSheetId> styleSheetId = java.util.Optional.empty();
        org.openqa.selenium.devtools.v144.css.model.StyleSheetOrigin origin = null;
        org.openqa.selenium.devtools.v144.css.model.CSSStyle style = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "type":
                    type = Type.fromString(input.nextString());
                    break;
                case "subsection":
                    subsection = java.util.Optional.ofNullable(Subsection.fromString(input.nextString()));
                    break;
                case "name":
                    name = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v144.css.model.Value.class));
                    break;
                case "styleSheetId":
                    styleSheetId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v144.dom.model.StyleSheetId.class));
                    break;
                case "origin":
                    origin = input.read(org.openqa.selenium.devtools.v144.css.model.StyleSheetOrigin.class);
                    break;
                case "style":
                    style = input.read(org.openqa.selenium.devtools.v144.css.model.CSSStyle.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CSSAtRule(type, subsection, name, styleSheetId, origin, style);
    }
}
