package org.openqa.selenium.devtools.v144.dom.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when `Element`'s adoptedStyleSheets are modified.
 */
@org.openqa.selenium.Beta()
public class AdoptedStyleSheetsModified {

    private final org.openqa.selenium.devtools.v144.dom.model.NodeId nodeId;

    private final java.util.List<org.openqa.selenium.devtools.v144.dom.model.StyleSheetId> adoptedStyleSheets;

    public AdoptedStyleSheetsModified(org.openqa.selenium.devtools.v144.dom.model.NodeId nodeId, java.util.List<org.openqa.selenium.devtools.v144.dom.model.StyleSheetId> adoptedStyleSheets) {
        this.nodeId = java.util.Objects.requireNonNull(nodeId, "nodeId is required");
        this.adoptedStyleSheets = java.util.Objects.requireNonNull(adoptedStyleSheets, "adoptedStyleSheets is required");
    }

    /**
     * Id of the node that has changed.
     */
    public org.openqa.selenium.devtools.v144.dom.model.NodeId getNodeId() {
        return nodeId;
    }

    /**
     * New adoptedStyleSheets array.
     */
    @Beta()
    public java.util.List<org.openqa.selenium.devtools.v144.dom.model.StyleSheetId> getAdoptedStyleSheets() {
        return adoptedStyleSheets;
    }

    private static AdoptedStyleSheetsModified fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v144.dom.model.NodeId nodeId = null;
        java.util.List<org.openqa.selenium.devtools.v144.dom.model.StyleSheetId> adoptedStyleSheets = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "nodeId":
                    nodeId = input.read(org.openqa.selenium.devtools.v144.dom.model.NodeId.class);
                    break;
                case "adoptedStyleSheets":
                    adoptedStyleSheets = input.readArray(org.openqa.selenium.devtools.v144.dom.model.StyleSheetId.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AdoptedStyleSheetsModified(nodeId, adoptedStyleSheets);
    }
}
