package org.openqa.selenium.devtools.v144.dom.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when a node's starting styles changes.
 */
@org.openqa.selenium.Beta()
public class AffectedByStartingStylesFlagUpdated {

    private final org.openqa.selenium.devtools.v144.dom.model.NodeId nodeId;

    private final java.lang.Boolean affectedByStartingStyles;

    public AffectedByStartingStylesFlagUpdated(org.openqa.selenium.devtools.v144.dom.model.NodeId nodeId, java.lang.Boolean affectedByStartingStyles) {
        this.nodeId = java.util.Objects.requireNonNull(nodeId, "nodeId is required");
        this.affectedByStartingStyles = java.util.Objects.requireNonNull(affectedByStartingStyles, "affectedByStartingStyles is required");
    }

    /**
     * The id of the node.
     */
    public org.openqa.selenium.devtools.v144.dom.model.NodeId getNodeId() {
        return nodeId;
    }

    /**
     * If the node has starting styles.
     */
    public java.lang.Boolean getAffectedByStartingStyles() {
        return affectedByStartingStyles;
    }

    private static AffectedByStartingStylesFlagUpdated fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v144.dom.model.NodeId nodeId = null;
        java.lang.Boolean affectedByStartingStyles = false;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "nodeId":
                    nodeId = input.read(org.openqa.selenium.devtools.v144.dom.model.NodeId.class);
                    break;
                case "affectedByStartingStyles":
                    affectedByStartingStyles = input.nextBoolean();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new AffectedByStartingStylesFlagUpdated(nodeId, affectedByStartingStyles);
    }
}
