package org.openqa.selenium.devtools.v144.domstorage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * DOM Storage identifier.
 */
public class StorageId {

    private final java.util.Optional<java.lang.String> securityOrigin;

    private final java.util.Optional<org.openqa.selenium.devtools.v144.domstorage.model.SerializedStorageKey> storageKey;

    private final java.lang.Boolean isLocalStorage;

    public StorageId(java.util.Optional<java.lang.String> securityOrigin, java.util.Optional<org.openqa.selenium.devtools.v144.domstorage.model.SerializedStorageKey> storageKey, java.lang.Boolean isLocalStorage) {
        this.securityOrigin = securityOrigin;
        this.storageKey = storageKey;
        this.isLocalStorage = java.util.Objects.requireNonNull(isLocalStorage, "isLocalStorage is required");
    }

    /**
     * Security origin for the storage.
     */
    public java.util.Optional<java.lang.String> getSecurityOrigin() {
        return securityOrigin;
    }

    /**
     * Represents a key by which DOM Storage keys its CachedStorageAreas
     */
    public java.util.Optional<org.openqa.selenium.devtools.v144.domstorage.model.SerializedStorageKey> getStorageKey() {
        return storageKey;
    }

    /**
     * Whether the storage is local storage (not session storage).
     */
    public java.lang.Boolean getIsLocalStorage() {
        return isLocalStorage;
    }

    private static StorageId fromJson(JsonInput input) {
        java.util.Optional<java.lang.String> securityOrigin = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v144.domstorage.model.SerializedStorageKey> storageKey = java.util.Optional.empty();
        java.lang.Boolean isLocalStorage = false;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "securityOrigin":
                    securityOrigin = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "storageKey":
                    storageKey = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v144.domstorage.model.SerializedStorageKey.class));
                    break;
                case "isLocalStorage":
                    isLocalStorage = input.nextBoolean();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new StorageId(securityOrigin, storageKey, isLocalStorage);
    }
}
