package org.openqa.selenium.devtools.v144.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class BackForwardCacheBlockingDetails {

    private final java.util.Optional<java.lang.String> url;

    private final java.util.Optional<java.lang.String> function;

    private final java.lang.Integer lineNumber;

    private final java.lang.Integer columnNumber;

    public BackForwardCacheBlockingDetails(java.util.Optional<java.lang.String> url, java.util.Optional<java.lang.String> function, java.lang.Integer lineNumber, java.lang.Integer columnNumber) {
        this.url = url;
        this.function = function;
        this.lineNumber = java.util.Objects.requireNonNull(lineNumber, "lineNumber is required");
        this.columnNumber = java.util.Objects.requireNonNull(columnNumber, "columnNumber is required");
    }

    /**
     * Url of the file where blockage happened. Optional because of tests.
     */
    public java.util.Optional<java.lang.String> getUrl() {
        return url;
    }

    /**
     * Function name where blockage happened. Optional because of anonymous functions and tests.
     */
    public java.util.Optional<java.lang.String> getFunction() {
        return function;
    }

    /**
     * Line number in the script (0-based).
     */
    public java.lang.Integer getLineNumber() {
        return lineNumber;
    }

    /**
     * Column number in the script (0-based).
     */
    public java.lang.Integer getColumnNumber() {
        return columnNumber;
    }

    private static BackForwardCacheBlockingDetails fromJson(JsonInput input) {
        java.util.Optional<java.lang.String> url = java.util.Optional.empty();
        java.util.Optional<java.lang.String> function = java.util.Optional.empty();
        java.lang.Integer lineNumber = 0;
        java.lang.Integer columnNumber = 0;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "url":
                    url = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "function":
                    function = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "lineNumber":
                    lineNumber = input.nextNumber().intValue();
                    break;
                case "columnNumber":
                    columnNumber = input.nextNumber().intValue();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new BackForwardCacheBlockingDetails(url, function, lineNumber, columnNumber);
    }
}
