package org.openqa.selenium.devtools.v144.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when frame has been detached from its parent.
 */
public class FrameDetached {

    public enum Reason {

        REMOVE("remove"), SWAP("swap");

        private String value;

        Reason(String value) {
            this.value = value;
        }

        public static Reason fromString(String s) {
            return java.util.Arrays.stream(Reason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within Reason "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static Reason fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final org.openqa.selenium.devtools.v144.page.model.FrameId frameId;

    private final Reason reason;

    public FrameDetached(org.openqa.selenium.devtools.v144.page.model.FrameId frameId, Reason reason) {
        this.frameId = java.util.Objects.requireNonNull(frameId, "frameId is required");
        this.reason = java.util.Objects.requireNonNull(reason, "reason is required");
    }

    /**
     * Id of the frame that has been detached.
     */
    public org.openqa.selenium.devtools.v144.page.model.FrameId getFrameId() {
        return frameId;
    }

    @Beta()
    public Reason getReason() {
        return reason;
    }

    private static FrameDetached fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v144.page.model.FrameId frameId = null;
        Reason reason = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "frameId":
                    frameId = input.read(org.openqa.selenium.devtools.v144.page.model.FrameId.class);
                    break;
                case "reason":
                    reason = Reason.fromString(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new FrameDetached(frameId, reason);
    }
}
