/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import org.jcodec.containers.mp4.boxes.FullBox;
import org.jcodec.containers.mp4.boxes.Header;

public class TimeToSampleBox
extends FullBox {
    private TimeToSampleEntry[] entries;

    public static String fourcc() {
        return "stts";
    }

    public TimeToSampleBox(TimeToSampleEntry[] timeToSamples) {
        super(new Header(TimeToSampleBox.fourcc()));
        this.entries = timeToSamples;
    }

    public TimeToSampleBox() {
        super(new Header(TimeToSampleBox.fourcc()));
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        int foo = input.getInt();
        this.entries = new TimeToSampleEntry[foo];
        for (int i = 0; i < foo; ++i) {
            this.entries[i] = new TimeToSampleEntry(input.getInt(), input.getInt());
        }
    }

    public TimeToSampleEntry[] getEntries() {
        return this.entries;
    }

    @Override
    public void doWrite(ByteBuffer out) {
        super.doWrite(out);
        out.putInt(this.entries.length);
        for (TimeToSampleEntry timeToSampleEntry : this.entries) {
            out.putInt(timeToSampleEntry.getSampleCount());
            out.putInt(timeToSampleEntry.getSampleDuration());
        }
    }

    public void setEntries(TimeToSampleEntry[] entries) {
        this.entries = entries;
    }

    public static class TimeToSampleEntry {
        int sampleCount;
        int sampleDuration;

        public TimeToSampleEntry(int sampleCount, int sampleDuration) {
            this.sampleCount = sampleCount;
            this.sampleDuration = sampleDuration;
        }

        public int getSampleCount() {
            return this.sampleCount;
        }

        public int getSampleDuration() {
            return this.sampleDuration;
        }

        public void setSampleDuration(int sampleDuration) {
            this.sampleDuration = sampleDuration;
        }

        public void setSampleCount(int sampleCount) {
            this.sampleCount = sampleCount;
        }

        public long getSegmentDuration() {
            return this.sampleCount * this.sampleDuration;
        }
    }
}

