/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import java.io.IOException;
import org.jcodec.movtool.streaming.CodecMeta;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;
import org.jcodec.movtool.streaming.tracks.ConcatPacket;

public class ConcatTrack
implements VirtualTrack {
    private VirtualTrack[] tracks;
    private int idx = 0;
    private VirtualPacket lastPacket;
    private double offsetPts = 0.0;
    private int offsetFn = 0;

    public ConcatTrack(VirtualTrack[] tracks) {
        this.tracks = tracks;
    }

    @Override
    public VirtualPacket nextPacket() throws IOException {
        while (this.idx < this.tracks.length) {
            VirtualTrack track = this.tracks[this.idx];
            VirtualPacket nextPacket = track.nextPacket();
            if (nextPacket == null) {
                ++this.idx;
                this.offsetPts += this.lastPacket.getPts() + this.lastPacket.getDuration();
                this.offsetFn += this.lastPacket.getFrameNo() + 1;
                continue;
            }
            this.lastPacket = nextPacket;
            return new ConcatPacket(nextPacket, this.offsetPts, this.offsetFn);
        }
        return null;
    }

    @Override
    public CodecMeta getCodecMeta() {
        return this.tracks[0].getCodecMeta();
    }

    @Override
    public VirtualTrack.VirtualEdit[] getEdits() {
        return null;
    }

    @Override
    public int getPreferredTimescale() {
        return this.tracks[0].getPreferredTimescale();
    }

    @Override
    public void close() throws IOException {
        for (int i = 0; i < this.tracks.length; ++i) {
            this.tracks[i].close();
        }
    }
}

